import { objectKeys } from '@sage/xtrem-shared';
import * as React from 'react';
import { localize } from '../../../../service/i18n-service';
import { getNestedFieldElementId } from '../../../../utils/abstract-fields-utils';
import { withoutNestedTechnical } from '../../../nested-fields';
import { TableTooltip } from '../../tooltip/tooltip';
export function ValidationCellRenderer(props) {
    const validationState = props.data?.__validationState || {};
    const numberOfErrors = objectKeys(validationState).length;
    const getTooltipContent = () => {
        const message = localize('@sage/xtrem-ui/validation-errors-number', 'Number of errors found in this line');
        return (React.createElement(React.Fragment, null,
            React.createElement("h6", { style: { margin: 0, padding: 0 } },
                message,
                ":\u00A0",
                React.createElement("strong", null, numberOfErrors)),
            React.createElement("ul", { className: "error-list error-list--inside-tooltip", "data-testid": "error-list" }, Object.entries(validationState).map(([key, value]) => {
                let columnName = props.api?.getColumn(key)?.getDefinition()?.headerName;
                const validationColDef = props.colDef;
                if (!columnName && validationColDef.context.getColumns) {
                    const columns = validationColDef.context.getColumns();
                    const columnDefinition = withoutNestedTechnical(columns).find(c => getNestedFieldElementId(c) === key);
                    if (columnDefinition) {
                        columnName = columnDefinition.properties.title;
                    }
                }
                const idOrKey = key.includes('__rowError') ? value.elementId : key;
                return (React.createElement("li", { key: key },
                    React.createElement("strong", null, columnName || idOrKey),
                    ":\u00A0",
                    value.message));
            }))));
    };
    if (numberOfErrors === 0) {
        return null;
    }
    return React.createElement(TableTooltip, { content: getTooltipContent() });
}
//# sourceMappingURL=table-validation-cell-renderer.js.map