import { isNil, noop } from 'lodash';
import * as React from 'react';
import { RecordActionType } from '../../../../service/collection-data-types';
import ConnectedTableDropdownActions from '../table-dropdown-actions/table-dropdown-actions';
import ConnectedTableInlineActions from '../table-inline-actions';
export function TableDropdownActionsCell(props) {
    const containerRef = React.useRef(null);
    const [data, setData] = React.useState(props.data);
    const isPhantomRow = React.useMemo(() => data?.__phantom !== undefined, [data]);
    const onPhantomCellFocus = React.useCallback((e) => {
        // Focus on the first available button (Confirm button if available, otherwise Clear button)
        const confirmButton = e.target?.querySelector?.('button[aria-label="Confirm"]');
        const clearButton = e.target?.querySelector?.('button[aria-label="Clear"]');
        (confirmButton || clearButton)?.focus?.();
    }, []);
    React.useEffect(() => {
        return props.colDef.cellRendererParams.collectionValue()?.subscribeForValueChanges((type, rowValue) => {
            if (type !== RecordActionType.MODIFIED || rowValue._id !== props.data._id) {
                return;
            }
            setData(rowValue);
        });
    }, [props.colDef.cellRendererParams, props.data._id]);
    // Focus on editing cell when in edit mode
    React.useEffect(() => {
        if (props.isEditing) {
            containerRef.current?.focus();
        }
    }, [props.isEditing]);
    // Focus phantom row's clear button in non edit mode
    React.useEffect(() => {
        if (!isPhantomRow || props.isEditing) {
            return noop;
        }
        props.eGridCell.addEventListener('focus', onPhantomCellFocus);
        return () => {
            props.eGridCell.removeEventListener('focus', onPhantomCellFocus);
        };
    }, [props.eGridCell, isPhantomRow, onPhantomCellFocus, props.isEditing]);
    if (data._id?.startsWith('__group-') || isNil(data?._id)) {
        return null;
    }
    const hasInlineActions = props.colDef.cellRendererParams.inlineActions.length > 0 && !isPhantomRow;
    const hasDropdownActions = props.colDef.cellRendererParams.dropdownActions.length > 0 || isPhantomRow;
    return (React.createElement("div", { className: "e-table-field-actions-container ag-cell-edit-wrapper ag-custom-component-popup", tabIndex: props.isEditing ? 0 : undefined, ref: containerRef, style: props.isEditing
            ? {
                width: props.eGridCell.clientWidth,
                boxSizing: 'border-box',
                height: '100%',
            }
            : undefined },
        hasInlineActions && (React.createElement(ConnectedTableInlineActions, { actions: props.colDef.cellRendererParams.inlineActions, api: props.api, column: props.column, fieldId: props.colDef.cellRendererParams.elementId, hasDropdownActions: hasDropdownActions, hasInlineActions: hasInlineActions, isDisabled: props.colDef.cellRendererParams.isParentFieldDisabled, isPhantomRow: data.__phantom !== undefined, level: props.colDef.cellRendererParams.level, recordId: data._id, rowIndex: props.node.rowIndex, rowValue: data, screenId: props.colDef.cellRendererParams.screenId })),
        hasDropdownActions && (React.createElement(ConnectedTableDropdownActions, { actions: props.colDef.cellRendererParams.dropdownActions, api: props.api, column: props.column, fieldId: props.colDef.cellRendererParams.elementId, hasDropdownActions: hasDropdownActions, hasInlineActions: hasInlineActions, isDisabled: props.colDef.cellRendererParams.isParentFieldDisabled, isPhantomRow: data.__phantom !== undefined, level: props.colDef.cellRendererParams.level, recordId: data._id, rowIndex: props.node.rowIndex, rowValue: data, screenId: props.colDef.cellRendererParams.screenId }))));
}
//# sourceMappingURL=table-dropdown-action-cell.js.map