import * as React from 'react';
import type { CollectionValue } from '../../../../service/collection-data-service';
import { type CellParams } from '../../../../utils/ag-grid/ag-grid-column-config';
import type { DropdownActionItem, DropdownActionItemOrMenuSeparator, Nested } from '../../../field/traits';
import type { NestedCollectionItemAction, NestedCollectionItemActionGroup, NestedCollectionItemActionOrMenuSeparator } from '../table-dropdown-actions/table-dropdown-action-types';
type ActionItemType = DropdownActionItem<any> | NestedCollectionItemAction<any> | NestedCollectionItemActionGroup<any>;
type ActionItemOrMenuSeparatorType = DropdownActionItemOrMenuSeparator<any> | NestedCollectionItemActionOrMenuSeparator<any> | NestedCollectionItemActionGroup<any>;
export interface TableDropdownActionsCellProps extends Omit<CellParams<Nested, any>, 'colDef'> {
    colDef: {
        cellRendererParams: {
            screenId: string;
            elementId: string;
            level: number;
            isParentFieldDisabled: boolean;
            isReadOnly: boolean;
            inlineActions: Array<ActionItemType>;
            dropdownActions: Array<ActionItemOrMenuSeparatorType>;
            collectionValue: () => CollectionValue | undefined;
        };
    };
    isEditing: boolean;
}
export declare function TableDropdownActionsCell(props: TableDropdownActionsCellProps): React.ReactElement | null;
export {};
//# sourceMappingURL=table-dropdown-action-cell.d.ts.map