import React from 'react';
import { TableTooltip } from '../../tooltip/tooltip';
import { getCellErrorMessage, getCellInfoMessage, getCellWarningMessage, } from '../../../../utils/ag-grid/ag-grid-column-config';
import { AUTO_COLUMN_ID } from '../../../../utils/table-component-utils';
import { localize } from '../../../../service/i18n-service';
import { isNil } from 'lodash';
import * as tokens from '@sage/design-tokens/js/base/common';
export function CellWrapper({ children, textAlign = 'left', ...props }) {
    const errorMessage = React.useMemo(() => getCellErrorMessage(props), [props]);
    const warningMessage = React.useMemo(() => getCellWarningMessage(props), [props]);
    const infoMessage = React.useMemo(() => getCellInfoMessage(props), [props]);
    const messageColor = React.useMemo(() => {
        if (errorMessage) {
            return tokens.colorsSemanticNegative500;
        }
        if (warningMessage) {
            return tokens.colorsSemanticCaution500;
        }
        if (infoMessage) {
            return tokens.colorsSemanticInfo500;
        }
        return undefined;
    }, [errorMessage, warningMessage, infoMessage]);
    const messageType = React.useMemo(() => {
        if (errorMessage) {
            return 'error';
        }
        if (warningMessage) {
            return 'warning';
        }
        if (infoMessage) {
            return 'info';
        }
        return undefined;
    }, [errorMessage, warningMessage, infoMessage]);
    const messageToDisplay = errorMessage || warningMessage || infoMessage;
    if (!props.node?.footer &&
        !props.isTree &&
        props.data &&
        props.data.__isGroup &&
        props.colDef.colId !== AUTO_COLUMN_ID) {
        // group row, but not group column => value should be empty
        return null;
    }
    if (!props.node?.footer &&
        !props.isTree &&
        props.data &&
        !props.data.__isGroup &&
        props.colDef.colId === AUTO_COLUMN_ID &&
        (!props.data.__aggFunc || props.data.__aggFunc === 'day')) {
        // child rows should have an empty group column
        return null;
    }
    if (props.node?.footer && props.colDef.colId === AUTO_COLUMN_ID) {
        return (React.createElement("div", { className: "e-table-group-total-row-cell" }, localize('@sage/xtrem-ui/table-group-total', 'Group total')));
    }
    if (props.node?.footer && !props.fieldProperties?.groupAggregationMethod) {
        return null;
    }
    const hasTooltip = !isNil(messageToDisplay);
    return (React.createElement("div", { className: "e-grid-error-indicator", style: {
            ...(hasTooltip && {
                display: 'flex',
                alignItems: 'center',
                justifyContent: 'space-between',
                border: `1px solid ${messageColor}`,
            }),
            padding: textAlign === 'left' ? '0 0 0 11px' : textAlign === 'right' ? '0 11px 0 0' : '0 11px',
            textAlign,
        } },
        React.createElement("div", { style: {
                display: 'flex',
                flexDirection: 'column',
                justifyContent: 'center',
                height: '100%',
                ...(textAlign === 'right' && { order: 1 }),
            } },
            React.createElement("div", { style: {
                    minWidth: 0,
                    overflow: 'hidden',
                    textOverflow: 'ellipsis',
                    whiteSpace: 'nowrap',
                } }, children)),
        hasTooltip && React.createElement(TableTooltip, { content: messageToDisplay, type: messageType, color: messageColor })));
}
//# sourceMappingURL=cell-wrapper.js.map