import * as React from 'react';
export const NoDataFound = React.memo(({ width = 300, height = 300 }) => {
    return (React.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", width: width, height: height, viewBox: "0 0 300 300", fill: "none" },
        React.createElement("path", { d: "M300 150C300 232.842 232.842 300 150 300C89.1166 300 36.7055 263.728 13.1972 211.614C11.4565 207.762 9.87682 203.816 8.45831 199.775C2.84107 183.782 -0.0190436 166.951 -2.78718e-05 150C-2.78718e-05 67.1556 67.1555 0 150 0C232.844 0 300 67.1556 300 150Z", fill: "black" }),
        React.createElement("path", { d: "M168.45 39.067C169.993 39.0433 171.473 38.4491 172.605 37.3989C173.736 36.3487 174.438 34.9168 174.577 33.3793C174.715 31.8419 174.279 30.3078 173.353 29.0728C172.427 27.8378 171.076 26.9893 169.562 26.691C168.047 26.3927 166.476 26.6657 165.151 27.4573C163.825 28.249 162.84 29.5032 162.385 30.9782C161.93 32.4532 162.037 34.0444 162.685 35.4452C163.334 36.846 164.478 37.9571 165.897 38.5642C166.703 38.9118 167.573 39.0833 168.45 39.067Z", fill: "#474748" }),
        React.createElement("path", { d: "M173.264 46.4053L174.586 32.8887L162.114 33.0914L160.789 46.6109L173.264 46.4053Z", fill: "#474748" }),
        React.createElement("path", { d: "M164.258 32.8359C164.257 33.785 164.607 34.701 165.241 35.4072C165.876 36.1135 166.749 36.56 167.692 36.6607C168.636 36.7614 169.584 36.5091 170.353 35.9526C171.121 35.396 171.657 34.5746 171.856 33.6465C172.055 32.7185 171.904 31.7497 171.431 30.9267C170.958 30.1038 170.197 29.485 169.295 29.1897C168.393 28.8944 167.414 28.9435 166.546 29.3274C165.678 29.7114 164.983 30.4031 164.594 31.2692C164.375 31.7627 164.261 32.2961 164.258 32.8359Z", fill: "#E9BEA0" }),
        React.createElement("path", { d: "M163.403 32.1586C166.066 31.9459 168.686 31.3519 171.181 30.3947L169.6 28.2725L164.825 29.7225L162.881 31.4697L163.403 32.1586Z", fill: "#474748" }),
        React.createElement("path", { d: "M166.228 78.1057C164.458 73.2196 161.797 65.1974 161.414 62.6724C160.969 59.6918 162.058 56.764 163.217 53.6696C163.967 51.6724 164.883 49.1974 165.211 46.5335C165.561 43.589 165.178 40.4057 162.972 37.3835C162.897 37.2751 162.817 37.164 162.731 37.0557C162.555 36.8396 162.364 36.6354 162.161 36.4446C162.056 36.3612 161.931 36.2112 161.808 36.1029C161.725 36.0251 161.642 35.9557 161.556 35.8835C161.469 35.8112 161.336 35.7112 161.217 35.6251L161.031 35.4946L160.931 35.4307L160.764 35.3251C160.667 35.2612 160.572 35.2085 160.486 35.1557C160.4 35.1029 160.278 35.0418 160.172 34.9918C160.014 34.9112 159.853 34.8418 159.692 34.7779L159.358 34.6501C159.347 34.6518 159.336 34.6509 159.325 34.6476C159.315 34.6442 159.305 34.6384 159.297 34.6307C159.185 34.5884 159.07 34.5532 158.953 34.5251L158.675 34.4501C158.611 34.4307 158.544 34.4196 158.475 34.4057C158.406 34.3918 158.256 34.3585 158.142 34.3418C156.761 34.1015 155.341 34.259 154.047 34.796C152.753 35.333 151.638 36.2273 150.834 37.3742C150.029 38.5212 149.568 39.8735 149.503 41.2731C149.439 42.6727 149.774 44.0618 150.469 45.2779C150.153 46.389 149.783 47.4696 149.358 48.5362C149.133 49.1446 148.897 49.7835 148.658 50.4557C147.297 54.2751 145.931 59.1529 146.794 64.9001C146.875 65.4807 147.006 66.1224 147.172 66.8446C147.267 67.2474 147.372 67.6779 147.483 68.1168C148.872 73.5585 151.675 81.3612 152.322 83.1557C152.885 84.7185 153.963 86.0437 155.378 86.914L155.439 86.9529C156.381 87.5289 157.441 87.885 158.54 87.9946C159.639 88.1043 160.749 87.9647 161.786 87.5862C162.181 87.4418 162.563 87.2643 162.928 87.0557C164.448 86.199 165.615 84.831 166.222 83.1948C166.829 81.5587 166.836 79.7604 166.242 78.1196L166.228 78.1057Z", fill: "white" }),
        React.createElement("path", { d: "M69.8583 172.142C78.1917 171.223 86.4555 169.811 94.6889 168.228C96.3315 167.913 97.9722 167.591 99.6111 167.261C107.819 157.22 117.744 143.714 123.5 130.989C129.306 118.159 133.706 103.995 136.486 92.4809C141.025 104.359 146.033 118.611 147.167 125.945C148.236 132.889 148.669 146.395 148.814 158.459C155.348 157.722 161.919 157.362 168.494 157.378C168.339 145.292 167.872 131.061 166.622 122.948C164.175 107.089 149.883 72.7309 148.261 68.8643L148.025 68.3476C144.156 60.4365 137.389 58.592 132.35 59.5059C125.942 60.6726 120.808 66.3031 120.167 72.9004C119.292 82.0004 114.031 104.167 105.569 122.864C96.15 143.684 72.0972 168.82 71.7472 169.184C70.9159 170.045 70.2502 171.051 69.7833 172.153C69.8078 172.147 69.833 172.143 69.8583 172.142Z", fill: "#5E5F5E" }),
        React.createElement("path", { d: "M147.942 94.1006C147.428 94.1015 146.92 93.9916 146.453 93.7784C145.984 93.5674 145.567 93.2564 145.231 92.8673C144.702 92.2525 144.216 91.6029 143.775 90.9228C143.303 90.2173 143.303 90.2173 142.9 90.0895C142.446 89.9398 142.027 89.7011 141.666 89.3875C141.305 89.0738 141.011 88.6914 140.8 88.2627C140.589 87.834 140.465 87.3674 140.436 86.8904C140.407 86.4134 140.474 85.9354 140.632 85.4843C140.79 85.0333 141.036 84.6182 141.356 84.2634C141.677 83.9086 142.064 83.6212 142.497 83.4179C142.929 83.2146 143.398 83.0995 143.875 83.0794C144.353 83.0592 144.83 83.1345 145.278 83.3006C147.928 84.2284 148.931 85.7201 149.722 86.9117C149.997 87.3407 150.301 87.7509 150.631 88.1395C151.084 88.6596 151.377 89.299 151.477 89.9815C151.577 90.664 151.478 91.3607 151.192 91.9886C150.907 92.6164 150.447 93.1489 149.867 93.5224C149.287 93.8959 148.612 94.0947 147.922 94.0951L147.942 94.1006Z", fill: "#E9BEA0" }),
        React.createElement("path", { d: "M162.972 37.3893C162.897 37.281 162.817 37.1699 162.731 37.0615C162.641 36.944 162.543 36.8327 162.439 36.7282C162.353 36.625 162.26 36.5276 162.161 36.4365C162.056 36.3532 161.931 36.2032 161.808 36.0949C161.725 36.0171 161.642 35.9477 161.556 35.8754C161.469 35.8032 161.336 35.7032 161.217 35.6171L161.031 35.4865L160.931 35.4227L160.764 35.3171C160.667 35.2532 160.572 35.2004 160.486 35.1477L160.172 34.9838C160.014 34.9032 159.853 34.8338 159.692 34.7699L159.358 34.6421C159.347 34.6438 159.336 34.6429 159.325 34.6395C159.315 34.6362 159.305 34.6304 159.297 34.6227C159.185 34.5804 159.07 34.5451 158.953 34.5171L158.675 34.4421C158.611 34.4227 158.544 34.4115 158.475 34.3977C158.406 34.3838 158.256 34.3504 158.142 34.3338C151.317 33.0782 137.156 37.8643 128.975 44.2727C125.25 47.1838 120.808 52.0504 120.808 58.5143C120.808 59.9032 121.008 61.7671 122.689 66.0143C123.647 68.4532 125.097 71.6893 127.275 76.0754C130.161 81.9088 132.997 87.0504 133.108 87.2671C134.051 88.9766 135.633 90.2429 137.507 90.7885C139.381 91.3341 141.395 91.1147 143.108 90.1782C143.121 90.1756 143.134 90.1698 143.144 90.1615C143.994 89.6951 144.743 89.0657 145.35 88.3094C145.956 87.5531 146.407 86.6847 146.677 85.7539C146.948 84.8231 147.032 83.8481 146.925 82.8847C146.819 81.9213 146.523 80.9884 146.056 80.1393C143.922 76.2643 141.658 71.8921 139.778 68.0227C138.031 64.4477 136.622 61.3004 135.942 59.3727C135.832 59.0677 135.74 58.7571 135.664 58.4421C136.103 57.6088 138.164 55.1366 143.942 52.3921C145.495 51.6556 147.088 51.0065 148.714 50.4477C152.028 49.3116 154.622 48.8504 155.536 48.8421C156.525 49.036 157.544 49.0236 158.528 48.8057C159.512 48.5877 160.441 48.1689 161.256 47.5754C161.653 47.2888 162.019 46.962 162.35 46.6004C163.488 45.3707 164.174 43.7898 164.293 42.1184C164.412 40.4469 163.958 38.7848 163.006 37.406L162.972 37.3893Z", fill: "white" }),
        React.createElement("path", { d: "M159.656 94.8589C159.437 94.8589 159.218 94.8393 159.003 94.8005C158.068 94.6288 157.24 94.0941 156.699 93.3133C156.157 92.5325 155.947 91.5692 156.114 90.6339C156.149 89.537 155.968 88.444 155.581 87.4172C155.219 86.5558 155.207 85.5876 155.547 84.7174C155.887 83.8473 156.552 83.1435 157.401 82.7548C158.251 82.3662 159.218 82.3232 160.099 82.635C160.979 82.9468 161.704 83.5889 162.119 84.4255C163.081 86.5283 163.575 89.8922 163.189 91.9255C163.038 92.7527 162.602 93.5007 161.956 94.0392C161.31 94.5778 160.496 94.8727 159.656 94.8728V94.8589Z", fill: "#E9BEA0" }),
        React.createElement("path", { d: "M266.667 177.731C266.667 179.822 265.211 181.85 262.522 183.769C249.364 193.136 206.35 200 155.322 200C104.294 200 61.2722 193.131 48.1194 183.764C45.4972 181.906 44.0639 179.947 43.9778 177.931V177.694C43.9749 177.684 43.9749 177.672 43.9778 177.661V177.756C44.0222 179.828 45.4778 181.833 48.1722 183.736C61.3944 193.086 104.369 199.936 155.325 199.936C206.281 199.936 249.256 193.086 262.481 183.736C265.178 181.825 266.633 179.811 266.667 177.731Z", fill: "#EAE9EA" }),
        React.createElement("path", { d: "M155.322 200.278C105.583 200.278 61.4333 193.581 47.9639 183.992C45.2333 182.048 43.7972 180.017 43.7139 177.948V177.7C43.7082 177.668 43.7082 177.635 43.7139 177.603L44.2361 175.381V177.775C44.2778 179.72 45.65 181.664 48.3139 183.539C61.7639 193.048 105.764 199.689 155.314 199.689C204.864 199.689 248.867 193.048 262.311 183.539C264.989 181.648 266.364 179.7 266.389 177.748H266.919C266.919 179.889 265.486 181.995 262.661 184C249.208 193.57 205.064 200.278 155.322 200.278Z", fill: "#30302F" }),
        React.createElement("path", { d: "M262.528 183.77C249.364 193.137 206.35 200.001 155.322 200.001C104.294 200.001 61.2722 193.131 48.1194 183.765L48.1722 183.729C61.3944 193.079 104.369 199.929 155.325 199.929C206.281 199.929 249.256 193.079 262.481 183.729L262.528 183.77Z", fill: "#EAE9EA" }),
        React.createElement("path", { d: "M155.322 200.279C105.583 200.279 61.4333 193.581 47.9639 183.993L47.6528 183.773L48.1778 183.42L48.325 183.526C61.7722 193.034 105.772 199.676 155.322 199.676C204.872 199.676 248.889 193.009 262.322 183.515L262.472 183.409L262.981 183.745L262.689 183.981C249.208 193.57 205.064 200.279 155.322 200.279Z", fill: "#30302F" }),
        React.createElement("path", { d: "M43.7167 177.779C43.7138 177.746 43.7138 177.714 43.7167 177.681V177.648C43.7167 171.556 55.3639 165.867 76.5417 161.631C97.5861 157.42 125.569 155.104 155.328 155.104C185.086 155.104 213.056 157.445 234.117 161.642C255.278 165.876 266.944 171.565 266.944 177.659V177.692H266.414V177.662C266.322 171.945 254.475 166.304 233.889 162.223C212.886 158.026 185 155.717 155.322 155.717C125.644 155.717 97.7583 158.023 76.7583 162.223C56.1833 166.326 44.3333 171.945 44.2417 177.654V177.748L43.7167 177.779Z", fill: "#30302F" }),
        React.createElement("path", { d: "M266.667 177.62V177.659C266.628 179.74 265.172 181.751 262.469 183.662C259.386 181.484 254.692 179.437 248.644 177.584L247.95 177.376L247.394 177.209C246.978 177.087 246.561 176.965 246.125 176.845L245.481 176.665C244.606 176.422 243.711 176.185 242.794 175.954L242.106 175.781C240.717 175.446 239.274 175.109 237.778 174.77L237.031 174.606L235.506 174.284L233.997 174.006L232.9 173.787L232.028 173.612L231.153 173.451C230.319 173.295 229.486 173.145 228.633 172.995L227.408 172.784L226.047 172.554C225.172 172.406 224.3 172.276 223.392 172.129C222.483 171.981 221.586 171.851 220.667 171.723C219.443 171.538 218.199 171.364 216.936 171.201L215.669 171.037L213.961 170.82L213.586 170.773C212.619 170.651 211.642 170.537 210.65 170.426C210.158 170.367 209.661 170.309 209.164 170.259L208.169 170.148L207.661 170.092L206.619 169.984C205.31 169.851 203.989 169.72 202.656 169.592C201.319 169.465 199.967 169.348 198.606 169.231C197.244 169.115 195.864 169.004 194.472 168.898C193.081 168.792 191.678 168.695 190.256 168.62L187.772 168.465C186.939 168.415 186.106 168.362 185.272 168.317H185.228L183.586 168.231L182.544 168.176L181.275 168.117L180.164 168.065L178.544 167.992C177.936 167.967 177.325 167.94 176.717 167.92C176.194 167.895 175.675 167.879 175.15 167.859C174.389 167.829 173.631 167.806 172.869 167.784C172.406 167.784 171.942 167.751 171.481 167.74L169.714 167.69L167.944 167.648L167.111 167.631C166.722 167.631 166.336 167.612 165.944 167.606L163.444 167.565H160.781C159.761 167.565 158.742 167.548 157.703 167.545H152.953C151.922 167.545 150.894 167.545 149.875 167.565H147.222L144.722 167.606C144.333 167.606 143.942 167.606 143.558 167.631L142.725 167.648L140.953 167.69L139.186 167.74C138.719 167.74 138.258 167.767 137.797 167.784C137.033 167.806 136.278 167.829 135.517 167.859C134.994 167.879 134.472 167.895 133.95 167.92C133.342 167.94 132.731 167.967 132.122 167.992L130.503 168.065C130.139 168.065 129.769 168.098 129.406 168.117L128.136 168.176L127.097 168.231L125.453 168.317H125.411C124.578 168.362 123.744 168.412 122.897 168.465L120.411 168.62C118.992 168.715 117.589 168.817 116.197 168.898C114.806 168.979 113.419 169.115 112.067 169.231C110.714 169.348 109.353 169.465 108.014 169.592C106.675 169.72 105.358 169.851 104.053 169.984L103.011 170.092L102.5 170.148L101.508 170.259C101.008 170.309 100.511 170.367 100.017 170.426C99.0306 170.537 98.05 170.651 97.0806 170.773L96.7083 170.82C95.8944 170.92 95.0861 171.026 94.2861 171.129C93.4861 171.231 92.6945 171.342 91.9083 171.454C90.7417 171.615 89.5769 171.782 88.4139 171.956L87.275 172.129C85.9278 172.337 84.6111 172.551 83.3139 172.776C82.8833 172.845 82.4417 172.92 82.0278 172.995L81.575 173.076C81.0195 173.17 80.4639 173.273 79.9306 173.354L79.5083 173.434L78.5611 173.612C77.9445 173.731 77.3333 173.845 76.7278 173.97C76.2056 174.07 75.6889 174.179 75.175 174.284L73.6111 174.615L72.8611 174.779C71.3685 175.108 69.9278 175.446 68.5389 175.792L67.8472 175.962C65.7806 176.49 63.8315 177.033 62 177.592C55.9528 179.445 51.2528 181.481 48.1694 183.67C45.4778 181.773 44.0222 179.762 43.9778 177.69V177.592C44.1722 165.323 93.9472 155.39 155.322 155.39C216.697 155.39 266.472 165.326 266.667 177.584V177.62Z", fill: "#474748" }),
        React.createElement("path", { d: "M266.389 177.906C266.376 178.078 266.352 178.25 266.317 178.42C266.314 178.449 266.308 178.478 266.3 178.506C266.058 179.617 265.383 180.728 264.281 181.811C263.719 182.366 263.114 182.875 262.472 183.333C259.397 181.203 254.775 179.186 248.725 177.331L248.028 177.117L247.472 176.956C247.056 176.828 246.639 176.706 246.197 176.592L245.556 176.389C244.622 176.131 243.742 175.9 242.867 175.681L242.453 175.578L242.175 175.508C240.803 175.167 239.344 174.825 237.842 174.492L237.089 174.328L235.556 174.011C235.059 173.906 234.556 173.808 234.047 173.72L232.936 173.497L232.081 173.339L231.206 173.175C230.372 173.02 229.539 172.87 228.683 172.72L227.458 172.506L226.111 172.278C225.239 172.131 224.367 171.986 223.45 171.85C222.533 171.714 221.644 171.572 220.728 171.445C219.517 171.264 218.261 171.092 216.994 170.925L216.439 170.853L215.719 170.756L214.011 170.539L213.639 170.497C212.669 170.375 211.689 170.258 210.7 170.145C210.206 170.089 209.708 170.031 209.208 169.978L206.661 169.7C205.352 169.563 204.031 169.432 202.7 169.306C201.506 169.195 200.217 169.078 198.642 168.945C197.067 168.811 195.717 168.703 194.508 168.617C193.119 168.511 191.731 168.408 190.294 168.339L187.794 168.183C186.961 168.131 186.128 168.083 185.275 168.036H185.133L183.592 167.953L182.481 167.895L181.294 167.842H181.253L180.194 167.792L177.972 167.695L176.731 167.645L175.164 167.583C174.406 167.556 173.647 167.531 172.883 167.508H172.844L171.486 167.467C170.906 167.447 170.322 167.433 169.719 167.42L167.95 167.378L167.047 167.358L165.936 167.333L163.436 167.292H162.425C162.247 167.292 162.072 167.275 161.894 167.292H160.783C159.761 167.281 158.734 167.274 157.703 167.272H152.931C151.894 167.272 150.867 167.272 149.853 167.292H147.181L144.681 167.333L143.569 167.358L142.669 167.378L140.897 167.42C140.314 167.42 139.733 167.447 139.133 167.467L137.778 167.5H137.744C136.981 167.522 136.217 167.547 135.458 167.575L133.894 167.636L132.656 167.686L130.433 167.783L129.367 167.833H129.336L128.156 167.883L127.022 167.945L125.494 168.028H125.356C124.522 168.075 123.689 168.122 122.839 168.175L120.356 168.331C118.933 168.425 117.531 168.528 116.136 168.608C114.928 168.695 113.614 168.8 112 168.936C110.386 169.072 109.139 169.186 107.95 169.297C106.613 169.425 105.291 169.557 103.983 169.692L101.439 169.97C100.939 170.022 100.439 170.081 99.9444 170.136C98.9555 170.25 97.9778 170.37 97.0083 170.489L96.6361 170.533C95.8194 170.631 95.0111 170.736 94.2111 170.845C93.4111 170.953 92.6139 171.053 91.8305 171.164C90.6472 171.331 89.5 171.503 88.3361 171.67L87.1944 171.842C85.7055 172.075 84.4167 172.289 83.2305 172.486L81.9417 172.711L81.7305 172.747L81.4916 172.789L79.8472 173.067L79.4222 173.147L78.8917 173.247L78.4778 173.325C77.8528 173.442 77.2416 173.561 76.6389 173.683C76.1166 173.789 75.5972 173.889 75.0805 173.997L73.5528 174.331L72.8055 174.492C71.3222 174.82 69.8639 175.161 68.475 175.508L67.8333 175.67H67.7778C67.4694 175.747 67.1611 175.825 66.8611 175.908C65.0861 176.367 63.4278 176.836 61.9111 177.297C55.8611 179.153 51.2361 181.17 48.1639 183.3C47.7667 183.022 47.3944 182.72 47.0528 182.428C45.3417 180.964 44.4028 179.472 44.2528 177.983C44.2528 177.904 44.2472 177.823 44.2361 177.742V177.72C44.2333 177.694 44.2333 177.668 44.2361 177.642V177.85C44.272 178.549 44.4617 179.231 44.7917 179.847C44.8435 179.947 44.8991 180.047 44.9583 180.147C45.0167 180.247 45.0805 180.347 45.1444 180.447C45.2078 180.544 45.2764 180.636 45.35 180.725C45.4222 180.808 45.4972 180.922 45.575 181.02C45.7146 181.199 45.8639 181.37 46.0222 181.533C46.1916 181.703 46.2778 181.811 46.4139 181.933C46.55 182.056 46.6917 182.189 46.8278 182.317L46.8472 182.333C46.9111 182.389 46.9667 182.447 47.0333 182.503C47.2759 182.708 47.5342 182.914 47.8083 183.12C47.8861 183.181 47.9667 183.239 48.0472 183.295L48.15 183.372L48.2833 183.467L48.3083 183.486C48.3861 183.539 48.4611 183.595 48.5417 183.647C51.5667 181.595 56.0917 179.633 61.9778 177.814C63.725 177.258 65.7 176.725 67.8111 176.186L68.4972 176.017C69.8861 175.67 71.3389 175.331 72.8167 175.006L73.5639 174.842C74.0666 174.731 74.5722 174.625 75.0889 174.522C75.6055 174.42 76.1166 174.306 76.6389 174.206C77.2389 174.083 77.8491 173.963 78.4694 173.845L78.8833 173.77L79.4166 173.67L79.8361 173.592C80.3778 173.489 80.9222 173.392 81.4778 173.314L81.7111 173.275L81.9305 173.236C82.3555 173.158 82.7833 173.081 83.2166 173.011C84.3833 172.811 85.6861 172.6 87.1722 172.372L88.3111 172.197C89.4518 172.025 90.6167 171.857 91.8055 171.692C92.5805 171.583 93.3722 171.475 94.1805 171.372L96.6667 171.111L97.0389 171.067C98.0111 170.945 98.9898 170.827 99.975 170.714C100.467 170.656 100.964 170.603 101.464 170.55L104.006 170.272C105.313 170.141 106.633 170.011 107.967 169.883C109.153 169.767 110.439 169.656 112.014 169.522C113.589 169.389 114.928 169.281 116.144 169.189C117.535 169.089 118.94 168.992 120.358 168.897L122.839 168.745C123.672 168.691 124.506 168.642 125.339 168.597H125.511L127.039 168.517L128.169 168.458L129.35 168.4H129.383C129.733 168.383 130.089 168.364 130.444 168.353L132.653 168.258L133.892 168.208L135.456 168.147C136.214 168.117 136.972 168.095 137.739 168.072H137.778L139.136 168.031L140.903 167.981L142.669 167.936L143.572 167.92L144.683 167.9C145.517 167.88 146.35 167.865 147.183 167.856H149.85C150.869 167.856 151.889 167.836 152.928 167.833H157.719C158.75 167.833 159.778 167.833 160.8 167.856H163.461C164.3 167.867 165.133 167.882 165.961 167.9L167.072 167.92L167.975 167.936L169.744 167.981L171.508 168.031L172.864 168.072H172.9C173.667 168.095 174.425 168.117 175.183 168.147L176.747 168.208L177.986 168.258L180.208 168.353C180.558 168.353 180.911 168.383 181.264 168.4H181.303L182.489 168.458L183.6 168.517L185.136 168.597H185.278C186.118 168.642 186.952 168.691 187.778 168.745L190.278 168.897L194.489 169.189C195.694 169.281 197.008 169.383 198.622 169.522C200.192 169.656 201.475 169.767 202.669 169.883C204 170.011 205.322 170.142 206.625 170.272L209.175 170.55C209.669 170.603 210.167 170.656 210.658 170.714C211.644 170.827 212.621 170.945 213.592 171.067L213.967 171.111L215.669 171.328L216.389 171.422L216.944 171.495C218.208 171.658 219.461 171.836 220.672 172.014C221.589 172.145 222.497 172.292 223.392 172.422C224.286 172.553 225.172 172.7 226.044 172.847L227.408 173.07L228.631 173.286C229.481 173.431 230.322 173.564 231.15 173.742L232.022 173.9L232.878 174.064L233.989 174.286C234.494 174.381 234.992 174.486 235.489 174.564C235.986 174.642 236.508 174.775 237.011 174.886L237.758 175.047C239.258 175.381 240.711 175.717 242.078 176.061L242.444 176.15L242.767 176.231C243.642 176.453 244.514 176.681 245.442 176.939L246.089 177.122C246.517 177.239 246.942 177.361 247.358 177.486L247.914 177.647L248.608 177.858C254.511 179.67 259.033 181.628 262.058 183.692L262.308 183.517L262.336 183.497L262.486 183.392C263.129 182.936 263.734 182.43 264.297 181.878C265.597 180.592 266.3 179.283 266.403 177.97V177.717C266.403 177.792 266.389 177.85 266.389 177.906ZM266.944 177.589C266.947 177.578 266.947 177.567 266.944 177.556V177.278C266.942 177.18 266.93 177.082 266.911 176.986C266.911 176.886 266.883 176.797 266.867 176.708C266.85 176.62 266.828 176.528 266.803 176.431C266.778 176.333 266.753 176.245 266.722 176.153C266.725 176.145 266.725 176.136 266.722 176.128C266.702 176.053 266.678 175.978 266.65 175.906C266.622 175.831 266.583 175.733 266.544 175.65C266.529 175.606 266.51 175.564 266.489 175.522C266.469 175.478 266.422 175.378 266.389 175.308C266.356 175.239 266.297 175.133 266.247 175.047L266.228 175.006C266.181 174.925 266.133 174.839 266.081 174.758L265.903 174.481C265.842 174.383 265.778 174.297 265.706 174.203L265.497 173.925L265.333 173.728C265.283 173.667 265.233 173.608 265.178 173.55C265.122 173.492 265.072 173.431 265.014 173.37L264.769 173.114L264.722 173.056L264.481 172.822C264.297 172.647 264.103 172.475 263.897 172.303C263.761 172.186 263.619 172.07 263.475 171.958L263.197 171.75C263.081 171.658 262.961 171.564 262.839 171.472C262.717 171.381 262.561 171.264 262.4 171.161L262.075 170.942L261.628 170.664L261.242 170.428C261.103 170.339 260.964 170.253 260.806 170.164L260.353 169.908C260.239 169.842 260.122 169.778 260.003 169.714C259.883 169.65 259.711 169.556 259.564 169.481L259.317 169.347L258.903 169.139C257.531 168.45 255.991 167.778 254.283 167.122L253.7 166.906C251.976 166.256 250.089 165.626 248.039 165.017L247.3 164.797C246.933 164.692 246.564 164.589 246.189 164.486L245 164.167C244.247 163.97 243.478 163.77 242.694 163.575C242.003 163.4 241.306 163.228 240.578 163.056L238.911 162.672L238.633 162.611L237.828 162.431C237.136 162.281 236.439 162.128 235.717 161.981C235.467 161.925 235.217 161.875 234.961 161.825L233.981 161.625L231.989 161.236L231.092 161.07C230.814 161.011 230.486 160.958 230.183 160.903C228.394 160.575 226.574 160.263 224.722 159.967L222.558 159.631L220.358 159.303C218.877 159.096 217.379 158.89 215.864 158.686L214.717 158.542L212.494 158.264L211.008 158.089L208.869 157.847C207.681 157.72 206.477 157.594 205.258 157.47L203.111 157.258L202.506 157.206L200.45 157.014C198.783 156.868 197.091 156.728 195.372 156.595C193.693 156.467 192.017 156.346 190.344 156.231H190.178L187.678 156.075L186.458 156H186.389L185.114 155.928H185.056L182.483 155.795C180.974 155.721 179.456 155.651 177.928 155.586L175.786 155.503C173.351 155.414 170.894 155.34 168.417 155.281C164.083 155.181 159.692 155.128 155.264 155.128C153.071 155.128 150.891 155.141 148.722 155.167C144 155.22 139.331 155.333 134.739 155.503L132.564 155.586C131.047 155.653 129.539 155.72 128.042 155.795L125.469 155.928H125.414L124.136 156L122.878 156.078L120.297 156.239C118.584 156.356 116.887 156.477 115.206 156.603C114.094 156.69 112.983 156.783 111.872 156.881L111.364 156.922L110.95 156.961L107.958 157.239L107.556 157.275L107.369 157.292C106.683 157.356 105.997 157.422 105.317 157.492L103.261 157.703L102.822 157.747L102.403 157.795C101.408 157.903 100.428 158.014 99.45 158.128L98.1139 158.283H98.0944L95.8722 158.561L93.5 158.867C92.8694 158.953 92.2416 159.036 91.6194 159.125L90.4444 159.292L90.2278 159.322L90.0305 159.353C88.9916 159.503 87.962 159.658 86.9417 159.817L85.8611 159.986L85.7055 160.011L84.6778 160.175L83.8028 160.325L82.8167 160.492C82.0444 160.622 81.2805 160.77 80.5222 160.897L79.2028 161.136L78.9472 161.186L78.4917 161.275L77.1694 161.531L76.5833 161.645L76.4611 161.667L74.8083 162.006L74.5305 162.064L72.7778 162.428L72.2611 162.545L71.7583 162.661L70.9972 162.836L70.3055 162.997C69.6167 163.161 68.9389 163.325 68.2778 163.492L67.4194 163.708C67.0444 163.803 66.675 163.9 66.3083 163.986L65.4583 164.211C64.7361 164.408 64.0305 164.606 63.3444 164.808L62.4833 165.064C62.2583 165.128 62.0361 165.197 61.8167 165.264L60.9833 165.525L60.2555 165.758L59.2166 166.111C57.65 166.628 56.1111 167.222 54.5944 167.864L53.8222 168.197L53.3694 168.4C52.9722 168.578 52.5805 168.761 52.1889 168.956C52.0389 169.022 51.8917 169.095 51.7444 169.167L51.3639 169.356C50.8278 169.633 50.3167 169.911 49.8361 170.189C49.6833 170.275 49.5583 170.364 49.4 170.45C49.2416 170.536 49.1083 170.622 48.9778 170.708L48.5694 170.986C48.4352 171.072 48.3054 171.165 48.1805 171.264L47.8389 171.506L47.4416 171.783L47.1055 172.061C46.9917 172.153 46.8805 172.242 46.7778 172.339C46.675 172.436 46.5667 172.517 46.4639 172.617L46.1722 172.895C46.0861 172.972 46.0028 173.053 45.9222 173.133L45.8805 173.175C45.7111 173.353 45.5444 173.525 45.3944 173.703C45.3111 173.8 45.2333 173.889 45.1555 173.981C45.0778 174.072 45.0111 174.164 44.9444 174.258C44.8057 174.435 44.6794 174.62 44.5667 174.814C44.4667 175 44.3472 175.189 44.2528 175.37L44.2361 175.406V175.425L44.2194 175.461L44.1889 175.522L44.1305 175.653C44.0944 175.742 44.0555 175.836 44.0194 175.931C43.9833 176.025 43.95 176.122 43.9222 176.222C43.8944 176.322 43.8639 176.411 43.8389 176.5C43.7944 176.683 43.7583 176.87 43.7305 177.056C43.7032 177.24 43.6884 177.425 43.6861 177.611V177.817C43.6911 177.957 43.7032 178.097 43.7222 178.236C43.7635 178.565 43.8389 178.889 43.9472 179.203C43.9525 179.221 43.959 179.239 43.9667 179.256C43.9715 179.275 43.978 179.293 43.9861 179.311C44.0522 179.5 44.1282 179.686 44.2139 179.867C44.2139 179.889 44.2361 179.911 44.25 179.933C44.3167 180.058 44.3833 180.183 44.4583 180.306V180.333C44.6394 180.637 44.836 180.931 45.0472 181.214C45.1278 181.322 45.2139 181.428 45.3028 181.536C45.7015 182.027 46.1482 182.476 46.6361 182.878L46.7 182.931L46.9083 183.095C47.1583 183.303 47.4222 183.511 47.7028 183.708H47.7167C47.7972 183.772 47.8861 183.833 47.9722 183.895L48.1278 184.003L48.2528 183.917L48.2778 183.895L48.3055 183.878L48.3555 183.842C48.4139 183.797 48.4778 183.756 48.5417 183.714L48.5889 183.681C51.6139 181.628 56.1389 179.667 62.025 177.847C63.7722 177.292 65.7472 176.758 67.8583 176.22L68.5444 176.05C69.9333 175.703 71.3861 175.364 72.8639 175.039L73.6111 174.875C74.1139 174.764 74.6194 174.658 75.1361 174.556C75.6528 174.453 76.1639 174.339 76.6861 174.239C77.2861 174.117 77.8963 173.996 78.5167 173.878L78.9305 173.803L79.4639 173.703L79.8833 173.625C80.425 173.522 80.9694 173.425 81.525 173.347L81.7583 173.308L81.9778 173.27C82.4028 173.192 82.8305 173.114 83.2639 173.045C84.4305 172.845 85.7333 172.633 87.2194 172.406L88.3583 172.231C89.5009 172.058 90.6657 171.89 91.8528 171.725C92.6278 171.617 93.4194 171.508 94.2278 171.406L96.6667 171.111L97.0389 171.067C98.0111 170.945 98.9898 170.827 99.975 170.714C100.467 170.656 100.964 170.603 101.464 170.55L104.006 170.272C105.313 170.141 106.633 170.011 107.967 169.883C109.153 169.767 110.439 169.656 112.014 169.522C113.589 169.389 114.928 169.281 116.144 169.189C117.535 169.089 118.94 168.992 120.358 168.897L122.839 168.745C123.672 168.691 124.506 168.642 125.339 168.597H125.511L127.039 168.517L128.169 168.458L129.35 168.4H129.383C129.733 168.383 130.089 168.364 130.444 168.353L132.653 168.258L133.892 168.208L135.456 168.147C136.214 168.117 136.972 168.095 137.739 168.072H137.778L139.136 168.031L140.903 167.981L142.669 167.936L143.572 167.92L144.683 167.9C145.517 167.88 146.35 167.865 147.183 167.856H149.85C150.869 167.856 151.889 167.836 152.928 167.833H157.719C158.75 167.833 159.778 167.833 160.8 167.856H163.461C164.3 167.867 165.133 167.882 165.961 167.9L167.072 167.92L167.975 167.936L169.744 167.981L171.508 168.031L172.864 168.072H172.9C173.667 168.095 174.425 168.117 175.183 168.147L176.747 168.208L177.986 168.258L180.208 168.353C180.558 168.353 180.911 168.383 181.264 168.4H181.303L182.489 168.458L183.6 168.517L185.136 168.597H185.278C186.118 168.642 186.952 168.691 187.778 168.745L190.278 168.897L194.489 169.189C195.694 169.281 197.008 169.383 198.622 169.522C200.192 169.656 201.475 169.767 202.669 169.883C204 170.011 205.322 170.142 206.625 170.272L209.175 170.55C209.669 170.603 210.167 170.656 210.658 170.714C211.644 170.827 212.621 170.945 213.592 171.067L213.967 171.111L215.669 171.328L216.389 171.422L216.944 171.495C218.208 171.658 219.461 171.836 220.672 172.014C221.589 172.145 222.497 172.292 223.392 172.422C224.286 172.553 225.172 172.7 226.044 172.847L227.408 173.07L228.631 173.286C229.481 173.431 230.322 173.564 231.15 173.742L232.022 173.9L232.878 174.064L233.989 174.286C234.494 174.381 234.992 174.486 235.489 174.564C235.986 174.642 236.508 174.775 237.011 174.886L237.758 175.047C239.258 175.381 240.711 175.717 242.078 176.061L242.444 176.15L242.767 176.231C243.642 176.453 244.514 176.681 245.442 176.939L246.089 177.122C246.517 177.239 246.942 177.361 247.358 177.486L247.914 177.647L248.608 177.858C254.511 179.67 259.033 181.628 262.058 183.692L262.083 183.708L262.289 183.853L262.317 183.872H262.342L262.367 183.892L262.494 183.981L262.647 183.872L262.908 183.683L262.931 183.667C263.424 183.311 263.898 182.928 264.35 182.52C265.197 181.772 265.895 180.87 266.406 179.861L266.422 179.831C266.523 179.627 266.611 179.416 266.683 179.2V179.175C266.703 179.117 266.722 179.058 266.739 179C266.756 178.942 266.764 178.917 266.775 178.875C266.8 178.772 266.822 178.672 266.842 178.57C266.891 178.334 266.923 178.096 266.939 177.856V177.733C266.942 177.722 266.942 177.709 266.939 177.697V177.606C266.941 177.6 266.943 177.595 266.944 177.589ZM242.183 175.514C240.811 175.172 239.353 174.831 237.85 174.497L237.097 174.333L235.556 174.011C235.059 173.906 234.556 173.808 234.047 173.72L232.936 173.497L232.081 173.339L231.206 173.175C230.372 173.02 229.539 172.87 228.683 172.72L227.458 172.506L226.111 172.278C225.239 172.131 224.367 171.986 223.45 171.85C222.533 171.714 221.644 171.572 220.728 171.445C219.517 171.264 218.261 171.092 216.994 170.925L216.439 170.853L215.719 170.756L214.011 170.539L213.639 170.497C212.669 170.375 211.689 170.258 210.7 170.145C210.206 170.089 209.708 170.031 209.208 169.978L206.661 169.7C205.352 169.563 204.031 169.432 202.7 169.306C201.506 169.195 200.217 169.078 198.642 168.945C197.067 168.811 195.717 168.703 194.508 168.617C193.119 168.511 191.731 168.408 190.294 168.339L187.794 168.183C186.961 168.131 186.128 168.083 185.275 168.036H185.133L183.592 167.953L182.481 167.895L181.294 167.842H181.253L180.194 167.792L177.972 167.695L176.731 167.645L175.164 167.583C174.406 167.556 173.647 167.531 172.883 167.508H172.844L171.486 167.467C170.906 167.447 170.322 167.433 169.719 167.42L167.95 167.378L167.047 167.358L165.936 167.333L163.436 167.292H162.425C162.247 167.292 162.072 167.275 161.894 167.292H160.783C159.761 167.281 158.734 167.274 157.703 167.272H152.931C151.894 167.272 150.867 167.272 149.853 167.292H147.181L144.681 167.333L143.569 167.358L142.669 167.378L140.897 167.42C140.314 167.42 139.733 167.447 139.133 167.467L137.778 167.5H137.744C136.981 167.522 136.217 167.547 135.458 167.575L133.894 167.636L132.656 167.686L130.433 167.783L129.367 167.833H129.336L128.156 167.883L127.022 167.945L125.494 168.028H125.356C124.522 168.075 123.689 168.122 122.839 168.175L120.356 168.331C118.933 168.425 117.531 168.528 116.136 168.608C114.928 168.695 113.614 168.8 112 168.936C110.386 169.072 109.139 169.186 107.95 169.297C106.613 169.425 105.291 169.557 103.983 169.692L101.439 169.97C100.939 170.022 100.439 170.081 99.9444 170.136C98.9555 170.25 97.9778 170.37 97.0083 170.489L96.6361 170.533C95.8194 170.631 95.0111 170.736 94.2111 170.845C93.4111 170.953 92.6139 171.053 91.8305 171.164C90.6472 171.331 89.5 171.503 88.3361 171.67L87.1944 171.842C85.7055 172.075 84.4167 172.289 83.2305 172.486L81.9417 172.711L81.7305 172.747L81.4916 172.789L79.8472 173.067L79.4222 173.147L78.8917 173.247L78.4778 173.325C77.8528 173.442 77.2416 173.561 76.6389 173.683C76.1166 173.789 75.5972 173.889 75.0805 173.997L73.5528 174.331L72.8055 174.492C71.3222 174.82 69.8639 175.161 68.475 175.508L67.8333 175.67H67.7778C67.4694 175.747 67.1611 175.825 66.8611 175.908C65.0861 176.367 63.4278 176.836 61.9111 177.297C55.8611 179.153 51.2361 181.17 48.1639 183.3C47.7667 183.022 47.3944 182.72 47.0528 182.428C45.3417 180.964 44.4028 179.472 44.2528 177.983C44.2528 177.904 44.2472 177.823 44.2361 177.742V177.72C44.2333 177.694 44.2333 177.668 44.2361 177.642V177.55C44.2972 173.739 49.6 169.961 59.2361 166.65C63.5123 165.214 67.8642 164.014 72.2722 163.056C73.7111 162.728 75.2028 162.411 76.7472 162.106C77.3028 161.995 77.8583 161.883 78.4361 161.778C86.9778 160.142 96.6028 158.808 106.983 157.806C119.95 156.553 134.092 155.814 148.769 155.647C150.938 155.621 153.118 155.608 155.311 155.608C159.743 155.608 164.128 155.659 168.467 155.761C193.153 156.339 216.008 158.539 233.875 162.106C237.023 162.733 239.963 163.396 242.694 164.092C255.983 167.47 264.172 171.592 266 175.811C266.12 176.093 266.213 176.386 266.278 176.686C266.29 176.731 266.299 176.776 266.306 176.822C266.308 176.835 266.308 176.848 266.306 176.861C266.299 176.89 266.299 176.919 266.306 176.947C266.328 177.083 266.344 177.219 266.353 177.356V177.575H266.631L266.386 177.597V177.875C266.373 178.048 266.349 178.219 266.314 178.389C266.311 178.418 266.305 178.447 266.297 178.475C266.056 179.586 265.381 180.697 264.278 181.781C263.716 182.331 263.111 182.837 262.469 183.292C259.394 181.161 254.772 179.145 248.722 177.289L248.025 177.075L247.469 176.914C247.053 176.786 246.636 176.664 246.194 176.55L245.556 176.389C244.622 176.131 243.742 175.9 242.867 175.681L242.453 175.578L242.183 175.514Z", fill: "#474748" }),
        React.createElement("path", { d: "M266.667 177.731V189.812C266.667 202.115 216.814 212.087 155.317 212.087C93.8195 212.087 43.9722 202.115 43.9722 189.812V177.754C44.0167 179.826 45.4722 181.831 48.1667 183.734C61.3889 193.084 104.364 199.934 155.319 199.934C206.275 199.934 249.25 193.084 262.475 183.734C265.178 181.826 266.633 179.812 266.667 177.731Z", fill: "#EAE9EA" }),
        React.createElement("path", { d: "M266.406 177.731V177.99C266.303 179.304 265.6 180.612 264.3 181.898C263.737 182.45 263.132 182.956 262.489 183.412L262.339 183.518L262.311 183.537L262.078 183.698H262.058C257.644 186.712 250.147 189.437 240.392 191.754C222.089 196.076 195.803 198.94 166.847 199.531C163.055 199.613 159.222 199.654 155.35 199.654C151.861 199.654 148.404 199.62 144.978 199.554C144.597 199.554 144.217 199.554 143.839 199.531C141.563 199.487 139.306 199.426 137.067 199.348L135.956 199.309C130.375 199.112 124.914 198.829 119.617 198.476C116.789 198.291 114.011 198.076 111.283 197.831C93.8917 196.329 78.625 193.943 67.0639 190.948L66.7861 190.879C65.3046 190.49 63.8787 190.089 62.5083 189.676C59.7126 188.854 56.9671 187.87 54.2861 186.729C54.1278 186.662 53.9694 186.595 53.8167 186.523C53.35 186.318 52.9 186.108 52.4667 185.895L52.0389 185.684C51.7556 185.545 51.4778 185.404 51.2056 185.259C50.975 185.137 50.75 185.015 50.5306 184.89L50.2528 184.731C50.0556 184.62 49.8667 184.506 49.6806 184.393C49.3111 184.165 48.9528 183.934 48.6111 183.704C48.5306 183.651 48.4556 183.595 48.3778 183.543L48.3528 183.523L48.2194 183.429L48.1167 183.351C48.0361 183.295 47.9556 183.237 47.8778 183.176C47.6019 182.97 47.3435 182.765 47.1028 182.559C46.747 182.256 46.4094 181.932 46.0917 181.59C45.9306 181.42 45.7833 181.248 45.6444 181.076C45.5667 180.979 45.4917 180.879 45.4194 180.781C45.3472 180.684 45.2806 180.587 45.2139 180.504C45.15 180.404 45.0861 180.304 45.0278 180.204C44.9694 180.104 44.9139 180.004 44.8611 179.904C44.5528 179.326 44.3638 178.692 44.3056 178.04C44.3079 177.959 44.3032 177.878 44.2917 177.798H43.7611V189.856C43.7611 191.115 44.2583 192.356 45.2417 193.576C46.5806 195.243 48.825 196.854 51.9083 198.393H51.9361C55.2496 199.975 58.687 201.284 62.2139 202.306C62.9 202.509 63.6028 202.718 64.3194 202.918H64.3472C67.9676 203.936 72.0278 204.897 76.5278 205.801C97.5833 210.026 125.556 212.343 155.322 212.343C185.089 212.343 213.056 210.015 234.108 205.812C235.097 205.627 236.062 205.427 237.003 205.212C256.336 201.045 266.936 195.604 266.936 189.804V177.731H266.406ZM266.406 189.676V189.806C266.406 195.231 255.806 200.579 237.178 204.637C236.144 204.859 235.087 205.08 234.006 205.298C213 209.501 185.047 211.818 155.322 211.818C125.597 211.818 97.6694 209.501 76.6417 205.298C72.5389 204.465 68.7806 203.595 65.4056 202.676H65.3889C64.45 202.418 63.5444 202.154 62.6667 201.893C58.3444 200.584 54.7222 199.198 51.875 197.754L51.8417 197.737C49.1139 196.348 47.0861 194.912 45.8194 193.448C44.7889 192.254 44.2583 191.045 44.2583 189.837V179.923C44.3222 180.056 44.3889 180.187 44.4667 180.32V180.348C44.6419 180.655 44.8387 180.949 45.0556 181.229C45.1361 181.337 45.2222 181.443 45.3111 181.551C45.7193 182.033 46.1652 182.481 46.6444 182.893L46.7083 182.945L46.9417 183.143C47.1778 183.343 47.4306 183.537 47.6972 183.734C47.7944 183.812 47.9 183.884 48.0056 183.956C51.3222 186.304 56.6 188.529 63.4972 190.531H63.5333C64.4833 190.807 65.462 191.079 66.4694 191.345H66.5083C73.4418 193.122 80.4634 194.535 87.5444 195.579C107.128 198.587 130.561 200.176 155.322 200.176C180.083 200.176 203.506 198.579 223.1 195.579C229.4 194.612 235.147 193.515 240.261 192.304C250.578 189.87 258.294 187.004 262.639 183.929L262.956 183.704C263.439 183.35 263.903 182.97 264.344 182.565C265.193 181.816 265.892 180.914 266.406 179.906V189.656V189.676Z", fill: "#30302F" }),
        React.createElement("path", { d: "M266.667 177.923V177.693H266.389V177.723L266.306 177.393H266.944V177.67H266.667V177.923Z", fill: "#30302F" }),
        React.createElement("path", { d: "M266.944 177.475V177.278C266.942 177.18 266.93 177.082 266.911 176.986C266.911 176.886 266.883 176.797 266.867 176.708C266.85 176.62 266.828 176.528 266.803 176.431C266.778 176.333 266.753 176.245 266.722 176.153C266.725 176.145 266.725 176.136 266.722 176.128C266.702 176.053 266.678 175.978 266.65 175.906C266.622 175.831 266.583 175.733 266.544 175.65C266.529 175.606 266.51 175.564 266.489 175.522C266.469 175.478 266.422 175.378 266.389 175.308C266.356 175.239 266.297 175.133 266.247 175.047L266.228 175.006C266.181 174.925 266.133 174.839 266.081 174.758L265.903 174.481C265.842 174.383 265.778 174.297 265.706 174.203L265.497 173.925L265.333 173.728C265.283 173.667 265.233 173.608 265.178 173.55C265.122 173.492 265.072 173.431 265.014 173.37L264.769 173.114L264.722 173.056L264.481 172.822C264.297 172.647 264.103 172.475 263.897 172.303C263.761 172.186 263.619 172.07 263.475 171.958L263.197 171.75C263.081 171.658 262.961 171.564 262.839 171.472C262.717 171.381 262.561 171.264 262.4 171.161L262.075 170.942L261.628 170.664L261.242 170.428C261.103 170.339 260.964 170.253 260.806 170.164L260.353 169.908C260.239 169.842 260.122 169.778 260.003 169.714C259.883 169.65 259.711 169.556 259.564 169.481L259.317 169.347L258.903 169.139C257.531 168.45 255.991 167.778 254.283 167.122L253.7 166.906C251.976 166.256 250.089 165.626 248.039 165.017L247.3 164.797C246.933 164.692 246.564 164.589 246.189 164.486L245 164.167C244.247 163.97 243.478 163.77 242.694 163.575C242.003 163.4 241.306 163.228 240.578 163.056L238.911 162.672L238.633 162.611L237.828 162.431C237.136 162.281 236.439 162.128 235.717 161.981C235.467 161.925 235.217 161.875 234.961 161.825L233.981 161.625L231.989 161.236L231.092 161.07C230.814 161.011 230.486 160.958 230.183 160.903C228.394 160.575 226.574 160.263 224.722 159.967L222.558 159.631L220.358 159.303C218.877 159.096 217.379 158.89 215.864 158.686L214.717 158.542L212.494 158.264L211.008 158.089L208.869 157.847C207.681 157.72 206.477 157.594 205.258 157.47L203.111 157.258L202.506 157.206L200.45 157.014C198.783 156.868 197.091 156.728 195.372 156.595C193.693 156.467 192.017 156.346 190.344 156.231H190.178L187.678 156.075L186.458 156H186.389L185.114 155.928H185.056L182.483 155.795C180.974 155.721 179.456 155.651 177.928 155.586L175.786 155.503C173.351 155.414 170.894 155.34 168.417 155.281C164.083 155.181 159.692 155.128 155.264 155.128C153.071 155.128 150.891 155.141 148.722 155.167C144 155.22 139.331 155.333 134.739 155.503L132.564 155.586C131.047 155.653 129.539 155.72 128.042 155.795L125.469 155.928H125.414L124.136 156L122.878 156.078L120.297 156.239C118.584 156.356 116.887 156.477 115.206 156.603C114.094 156.69 112.983 156.783 111.872 156.881L111.364 156.922L110.95 156.961L107.958 157.239L107.556 157.275L107.369 157.292C106.683 157.356 105.997 157.422 105.317 157.492L103.261 157.703L102.822 157.747L102.403 157.795C101.408 157.903 100.428 158.014 99.45 158.128L98.1139 158.283H98.0944L95.8722 158.561L93.5 158.867C92.8694 158.953 92.2416 159.036 91.6194 159.125L90.4444 159.292L90.2278 159.322L90.0305 159.353C88.9916 159.503 87.962 159.658 86.9417 159.817L85.8611 159.986L85.7055 160.011L84.6778 160.175L83.8028 160.325L82.8167 160.492C82.0444 160.622 81.2805 160.77 80.5222 160.897L79.2028 161.136L78.9472 161.186L78.4917 161.275L77.1694 161.531L76.5833 161.645L76.4611 161.667L74.8083 162.006L74.5305 162.064L72.7778 162.428L72.2611 162.545L71.7583 162.661L70.9972 162.836L70.3055 162.997C69.6167 163.161 68.9389 163.325 68.2778 163.492L67.4194 163.708C67.0444 163.803 66.675 163.9 66.3083 163.986L65.4583 164.211C64.7361 164.408 64.0305 164.606 63.3444 164.808L62.4833 165.064C62.2583 165.128 62.0361 165.197 61.8167 165.264L60.9833 165.525L60.2555 165.758L59.2166 166.111C57.65 166.628 56.1111 167.222 54.5944 167.864L53.8222 168.197L53.3694 168.4C52.9722 168.578 52.5805 168.761 52.1889 168.956C52.0389 169.022 51.8917 169.095 51.7444 169.167L51.3639 169.356C50.8278 169.633 50.3167 169.911 49.8361 170.189C49.6833 170.275 49.5583 170.364 49.4 170.45C49.2416 170.536 49.1083 170.622 48.9778 170.708L48.5694 170.986C48.4352 171.072 48.3054 171.165 48.1805 171.264L47.8389 171.506L47.4416 171.783L47.1055 172.061C46.9917 172.153 46.8805 172.242 46.7778 172.339C46.675 172.436 46.5667 172.517 46.4639 172.617L46.1722 172.895C46.0861 172.972 46.0028 173.053 45.9222 173.133L45.8805 173.175C45.7111 173.353 45.5444 173.525 45.3944 173.703C45.3111 173.8 45.2333 173.889 45.1555 173.981C45.0778 174.072 45.0111 174.164 44.9444 174.258C44.8057 174.435 44.6794 174.62 44.5667 174.814C44.4667 175 44.3472 175.189 44.2528 175.37L44.2361 175.406V175.425L44.2194 175.461L44.1889 175.522L44.1305 175.653C44.0944 175.742 44.0555 175.836 44.0194 175.931C43.9833 176.025 43.95 176.122 43.9222 176.222C43.8944 176.322 43.8639 176.411 43.8389 176.5C43.7944 176.683 43.7583 176.87 43.7305 177.056C43.7032 177.24 43.6884 177.425 43.6861 177.611V189.075H43.7222L43.9528 189.125H43.9861L44.2194 189.172H44.25L56.0333 191.672L56.1194 191.692H56.25L62.0972 192.928L62.1944 192.947L69.1944 194.386L96.7444 200.22L141.389 206.42H141.417L149.05 205.767L230.95 198.778L239.311 196.667L255.956 192.381L266.406 189.692L266.683 189.625L266.961 189.553V177.564C266.949 177.536 266.943 177.506 266.944 177.475ZM266.389 189.142L258.831 191.086L239.442 196.086L230.869 198.292L146.147 205.514L141.425 205.917L119.003 202.806L101.908 200.439L96.825 199.747L68.8889 193.836L60.9472 192.17L57.6639 191.472L57.575 191.456L44.2417 188.611V177.586C44.3028 173.775 49.6055 169.997 59.2417 166.689C63.5179 165.249 67.8698 164.043 72.2778 163.078C73.7204 162.752 75.212 162.435 76.7528 162.128L78.4194 161.803C86.9639 160.167 96.5889 158.833 106.972 157.831C119.942 156.578 134.089 155.839 148.772 155.672C150.942 155.647 153.128 155.633 155.319 155.633C159.747 155.633 164.131 155.684 168.469 155.786C193.158 156.364 216.017 158.564 233.883 162.128C237.031 162.758 239.971 163.42 242.703 164.114C255.975 167.5 264.167 171.603 266.006 175.833C266.126 176.116 266.219 176.409 266.283 176.708C266.297 176.753 266.306 176.798 266.311 176.845C266.314 176.857 266.314 176.871 266.311 176.883C266.324 176.948 266.335 177.012 266.344 177.075C266.353 177.122 266.358 177.169 266.361 177.217C266.358 177.277 266.364 177.336 266.378 177.395L266.389 189.142Z", fill: "#30302F" }),
        React.createElement("path", { d: "M266.667 177.731V189.812C266.667 202.115 216.814 212.087 155.317 212.087C93.8195 212.087 43.9722 202.115 43.9722 189.812V177.754C44.0167 179.826 45.4722 181.831 48.1667 183.734C61.3889 193.084 104.364 199.934 155.319 199.934C206.275 199.934 249.25 193.084 262.475 183.734C265.178 181.826 266.633 179.812 266.667 177.731Z", fill: "#30302F" }),
        React.createElement("path", { d: "M266.406 177.731V177.99C266.303 179.304 265.6 180.612 264.3 181.898C263.737 182.45 263.132 182.956 262.489 183.412L262.339 183.518L262.311 183.537L262.078 183.698H262.058C257.644 186.712 250.147 189.437 240.392 191.754C222.089 196.076 195.803 198.94 166.847 199.531C163.055 199.613 159.222 199.654 155.35 199.654C151.861 199.654 148.404 199.62 144.978 199.554C144.597 199.554 144.217 199.554 143.839 199.531C141.563 199.487 139.306 199.426 137.067 199.348L135.956 199.309C130.375 199.112 124.914 198.829 119.617 198.476C116.789 198.291 114.011 198.076 111.283 197.831C93.8917 196.329 78.625 193.943 67.0639 190.948L66.7861 190.879C65.3046 190.49 63.8787 190.089 62.5083 189.676C59.7126 188.854 56.9671 187.87 54.2861 186.729C54.1278 186.662 53.9694 186.595 53.8167 186.523C53.35 186.318 52.9 186.108 52.4667 185.895L52.0389 185.684C51.7556 185.545 51.4778 185.404 51.2056 185.259C50.975 185.137 50.75 185.015 50.5306 184.89L50.2528 184.731C50.0556 184.62 49.8667 184.506 49.6806 184.393C49.3111 184.165 48.9528 183.934 48.6111 183.704C48.5306 183.651 48.4556 183.595 48.3778 183.543L48.3528 183.523L48.2194 183.429L48.1167 183.351C48.0361 183.295 47.9556 183.237 47.8778 183.176C47.6019 182.97 47.3435 182.765 47.1028 182.559C46.747 182.256 46.4094 181.932 46.0917 181.59C45.9306 181.42 45.7833 181.248 45.6444 181.076C45.5667 180.979 45.4917 180.879 45.4194 180.781C45.3472 180.684 45.2806 180.587 45.2139 180.504C45.15 180.404 45.0861 180.304 45.0278 180.204C44.9694 180.104 44.9139 180.004 44.8611 179.904C44.5528 179.326 44.3638 178.692 44.3056 178.04C44.3079 177.959 44.3032 177.878 44.2917 177.798H43.7611V189.856C43.7611 191.115 44.2583 192.356 45.2417 193.576C46.5806 195.243 48.825 196.854 51.9083 198.393H51.9361C55.2496 199.975 58.687 201.284 62.2139 202.306C62.9 202.509 63.6028 202.718 64.3194 202.918H64.3472C67.9676 203.936 72.0278 204.897 76.5278 205.801C97.5833 210.026 125.556 212.343 155.322 212.343C185.089 212.343 213.056 210.015 234.108 205.812C235.097 205.627 236.062 205.427 237.003 205.212C256.336 201.045 266.936 195.604 266.936 189.804V177.731H266.406ZM266.406 189.676V189.806C266.406 195.231 255.806 200.579 237.178 204.637C236.144 204.859 235.087 205.08 234.006 205.298C213 209.501 185.047 211.818 155.322 211.818C125.597 211.818 97.6694 209.501 76.6417 205.298C72.5389 204.465 68.7806 203.595 65.4056 202.676H65.3889C64.45 202.418 63.5444 202.154 62.6667 201.893C58.3444 200.584 54.7222 199.198 51.875 197.754L51.8417 197.737C49.1139 196.348 47.0861 194.912 45.8194 193.448C44.7889 192.254 44.2583 191.045 44.2583 189.837V179.923C44.3222 180.056 44.3889 180.187 44.4667 180.32V180.348C44.6419 180.655 44.8387 180.949 45.0556 181.229C45.1361 181.337 45.2222 181.443 45.3111 181.551C45.7193 182.033 46.1652 182.481 46.6444 182.893L46.7083 182.945L46.9417 183.143C47.1778 183.343 47.4306 183.537 47.6972 183.734C47.7944 183.812 47.9 183.884 48.0056 183.956C51.3222 186.304 56.6 188.529 63.4972 190.531H63.5333C64.4833 190.807 65.462 191.079 66.4694 191.345H66.5083C73.4418 193.122 80.4634 194.535 87.5444 195.579C107.128 198.587 130.561 200.176 155.322 200.176C180.083 200.176 203.506 198.579 223.1 195.579C229.4 194.612 235.147 193.515 240.261 192.304C250.578 189.87 258.294 187.004 262.639 183.929L262.956 183.704C263.439 183.35 263.903 182.97 264.344 182.565C265.193 181.816 265.892 180.914 266.406 179.906V189.656V189.676Z", fill: "#30302F" }),
        React.createElement("path", { d: "M58.0555 203.906C56.4975 203.898 54.999 203.307 53.855 202.249C52.7111 201.191 52.0047 199.744 51.8751 198.191C51.7454 196.639 52.2019 195.094 53.1546 193.861C54.1073 192.628 55.4871 191.797 57.0222 191.531L62.3583 190.625C63.9831 190.319 65.6628 190.672 67.0279 191.604C68.3931 192.537 69.3317 193.974 69.6375 195.599C69.9432 197.224 69.591 198.903 68.6582 200.268C67.7255 201.633 66.2887 202.572 64.6638 202.878L64.4444 202.914L59.1083 203.82C58.7605 203.879 58.4083 203.908 58.0555 203.906Z", fill: "#474748" }),
        React.createElement("path", { d: "M147.356 68.1533C144.022 69.3756 135.864 69.2922 131.8 60.1256C129.764 55.5089 130.294 49.6422 139.342 44.0811C154.794 34.5867 159.897 37.6422 161.086 45.0117C162.128 51.5089 157.85 64.2867 147.356 68.1533Z", fill: "white" }),
        React.createElement("path", { d: "M124.072 189.911C124.266 189.912 124.456 189.855 124.617 189.748C124.779 189.64 124.905 189.488 124.98 189.309C125.055 189.13 125.075 188.932 125.037 188.742C125 188.552 124.907 188.377 124.77 188.239C124.634 188.102 124.459 188.008 124.269 187.97C124.079 187.931 123.882 187.95 123.702 188.024C123.523 188.097 123.369 188.223 123.261 188.384C123.153 188.545 123.095 188.734 123.094 188.928C123.094 189.057 123.119 189.184 123.168 189.303C123.217 189.423 123.289 189.531 123.38 189.622C123.47 189.713 123.578 189.786 123.697 189.836C123.816 189.885 123.943 189.911 124.072 189.911Z", fill: "white" }),
        React.createElement("path", { d: "M147.658 191.945C147.852 191.945 148.041 191.887 148.202 191.78C148.362 191.673 148.488 191.52 148.562 191.341C148.636 191.163 148.655 190.966 148.617 190.776C148.58 190.587 148.486 190.412 148.35 190.276C148.213 190.139 148.039 190.046 147.849 190.008C147.659 189.97 147.463 189.99 147.284 190.064C147.105 190.138 146.953 190.263 146.845 190.424C146.738 190.585 146.681 190.774 146.681 190.967C146.681 191.226 146.785 191.474 146.968 191.658C147.151 191.841 147.399 191.944 147.658 191.945Z", fill: "white" }),
        React.createElement("path", { d: "M117.667 192.822C117.861 192.823 118.05 192.766 118.212 192.659C118.373 192.551 118.5 192.399 118.574 192.22C118.649 192.041 118.669 191.844 118.632 191.653C118.594 191.463 118.501 191.288 118.365 191.15C118.228 191.013 118.054 190.919 117.863 190.881C117.673 190.842 117.476 190.861 117.297 190.935C117.117 191.009 116.964 191.134 116.856 191.295C116.747 191.456 116.689 191.645 116.689 191.839C116.69 192.098 116.793 192.346 116.976 192.53C117.159 192.713 117.408 192.816 117.667 192.817V192.822Z", fill: "white" }),
        React.createElement("path", { d: "M66.9445 182.325C67.1384 182.326 67.3281 182.269 67.4897 182.162C67.6512 182.054 67.7774 181.902 67.8521 181.723C67.9268 181.544 67.9468 181.347 67.9095 181.156C67.8722 180.966 67.7793 180.791 67.6425 180.653C67.5058 180.516 67.3314 180.422 67.1412 180.384C66.9511 180.345 66.7539 180.364 66.5746 180.438C66.3952 180.512 66.2417 180.637 66.1335 180.798C66.0253 180.959 65.9672 181.148 65.9667 181.342C65.9667 181.602 66.0695 181.851 66.2527 182.035C66.4359 182.22 66.6846 182.324 66.9445 182.325Z", fill: "white" }),
        React.createElement("path", { d: "M91.5166 179.264C91.6677 179.264 91.8154 179.219 91.941 179.135C92.0667 179.051 92.1646 178.932 92.2224 178.793C92.2802 178.653 92.2953 178.499 92.2659 178.351C92.2364 178.203 92.1636 178.067 92.0568 177.96C91.95 177.853 91.8138 177.78 91.6657 177.751C91.5175 177.722 91.3639 177.737 91.2243 177.794C91.0847 177.852 90.9654 177.95 90.8815 178.076C90.7976 178.201 90.7527 178.349 90.7527 178.5C90.7535 178.703 90.8342 178.896 90.9773 179.04C91.1204 179.183 91.3143 179.263 91.5166 179.264Z", fill: "white" }),
        React.createElement("path", { d: "M243.222 181.595C243.373 181.595 243.521 181.55 243.647 181.466C243.772 181.382 243.87 181.263 243.928 181.124C243.986 180.984 244.001 180.83 243.971 180.682C243.942 180.534 243.869 180.398 243.762 180.291C243.656 180.184 243.519 180.112 243.371 180.082C243.223 180.053 243.069 180.068 242.93 180.126C242.79 180.183 242.671 180.281 242.587 180.407C242.503 180.532 242.458 180.68 242.458 180.831C242.458 181.034 242.539 181.228 242.682 181.371C242.825 181.515 243.02 181.595 243.222 181.595Z", fill: "white" }),
        React.createElement("path", { d: "M225.353 177.884C225.504 177.884 225.652 177.839 225.777 177.755C225.903 177.672 226.001 177.552 226.058 177.413C226.116 177.273 226.131 177.119 226.102 176.971C226.072 176.823 226 176.687 225.893 176.58C225.786 176.473 225.65 176.401 225.502 176.371C225.354 176.342 225.2 176.357 225.06 176.415C224.921 176.472 224.802 176.57 224.718 176.696C224.634 176.822 224.589 176.969 224.589 177.12C224.59 177.323 224.67 177.517 224.813 177.66C224.957 177.803 225.15 177.883 225.353 177.884Z", fill: "white" }),
        React.createElement("path", { d: "M191.642 193.084C191.887 193.085 192.126 193.013 192.33 192.877C192.534 192.741 192.694 192.548 192.788 192.322C192.882 192.096 192.907 191.847 192.86 191.606C192.813 191.366 192.695 191.145 192.522 190.971C192.35 190.798 192.129 190.679 191.889 190.631C191.649 190.582 191.399 190.606 191.173 190.7C190.946 190.793 190.752 190.951 190.616 191.155C190.479 191.358 190.406 191.598 190.406 191.843C190.405 192.005 190.437 192.166 190.499 192.317C190.561 192.467 190.652 192.604 190.766 192.719C190.881 192.835 191.018 192.926 191.168 192.989C191.318 193.051 191.479 193.084 191.642 193.084Z", fill: "white" }),
        React.createElement("path", { d: "M200.378 180.279C200.623 180.279 200.862 180.207 201.066 180.071C201.271 179.936 201.43 179.742 201.524 179.516C201.618 179.29 201.643 179.041 201.596 178.801C201.549 178.56 201.431 178.339 201.258 178.166C201.086 177.992 200.865 177.873 200.625 177.825C200.385 177.777 200.136 177.801 199.909 177.894C199.682 177.987 199.489 178.146 199.352 178.349C199.215 178.552 199.142 178.792 199.142 179.037C199.141 179.2 199.173 179.361 199.235 179.511C199.297 179.662 199.388 179.798 199.503 179.914C199.617 180.029 199.754 180.121 199.904 180.183C200.054 180.246 200.215 180.278 200.378 180.279Z", fill: "white" }),
        React.createElement("path", { d: "M116.517 186.97C116.762 186.971 117.001 186.898 117.205 186.763C117.409 186.627 117.569 186.434 117.663 186.208C117.757 185.982 117.782 185.733 117.735 185.492C117.688 185.252 117.57 185.031 117.397 184.857C117.225 184.683 117.004 184.565 116.764 184.517C116.524 184.468 116.274 184.492 116.048 184.585C115.821 184.679 115.627 184.837 115.491 185.04C115.354 185.244 115.281 185.483 115.281 185.728C115.28 185.891 115.312 186.052 115.374 186.203C115.436 186.353 115.527 186.49 115.641 186.605C115.756 186.72 115.893 186.812 116.043 186.875C116.193 186.937 116.354 186.97 116.517 186.97Z", fill: "white" }),
        React.createElement("path", { d: "M214.014 180.112C214.079 180.112 214.142 180.093 214.196 180.058C214.251 180.022 214.293 179.971 214.318 179.912C214.344 179.852 214.351 179.786 214.339 179.723C214.327 179.659 214.296 179.6 214.25 179.554C214.205 179.508 214.147 179.476 214.083 179.463C214.02 179.45 213.954 179.456 213.894 179.48C213.834 179.504 213.782 179.546 213.746 179.599C213.709 179.653 213.689 179.716 213.689 179.781C213.688 179.824 213.696 179.867 213.712 179.907C213.728 179.947 213.752 179.984 213.782 180.014C213.812 180.045 213.848 180.07 213.888 180.086C213.928 180.103 213.971 180.112 214.014 180.112Z", fill: "white" }),
        React.createElement("path", { d: "M246.336 182.734C246.401 182.734 246.464 182.714 246.518 182.678C246.572 182.642 246.614 182.591 246.639 182.531C246.664 182.471 246.67 182.406 246.658 182.342C246.645 182.278 246.614 182.22 246.568 182.174C246.522 182.128 246.464 182.097 246.4 182.084C246.336 182.072 246.271 182.078 246.211 182.103C246.151 182.128 246.1 182.17 246.064 182.224C246.028 182.278 246.008 182.341 246.008 182.406C246.008 182.449 246.016 182.491 246.032 182.53C246.048 182.57 246.072 182.606 246.102 182.637C246.131 182.667 246.167 182.691 246.206 182.708C246.246 182.725 246.288 182.733 246.331 182.734H246.336Z", fill: "white" }),
        React.createElement("path", { d: "M202.367 191.759C202.431 191.76 202.495 191.741 202.549 191.705C202.603 191.67 202.646 191.619 202.671 191.559C202.696 191.5 202.704 191.434 202.691 191.37C202.679 191.306 202.649 191.248 202.603 191.201C202.558 191.155 202.5 191.124 202.436 191.11C202.373 191.097 202.307 191.103 202.247 191.127C202.186 191.152 202.135 191.193 202.098 191.247C202.062 191.3 202.042 191.364 202.042 191.429C202.041 191.472 202.049 191.515 202.065 191.555C202.081 191.595 202.105 191.631 202.135 191.662C202.165 191.693 202.201 191.717 202.241 191.734C202.281 191.75 202.323 191.759 202.367 191.759Z", fill: "white" }),
        React.createElement("path", { d: "M176.742 193.798C176.806 193.799 176.87 193.78 176.924 193.744C176.978 193.709 177.021 193.658 177.046 193.598C177.071 193.539 177.079 193.473 177.066 193.409C177.054 193.345 177.024 193.287 176.978 193.241C176.933 193.194 176.875 193.163 176.811 193.149C176.748 193.136 176.682 193.142 176.622 193.166C176.561 193.191 176.51 193.232 176.473 193.286C176.437 193.34 176.417 193.403 176.417 193.468C176.417 193.554 176.451 193.638 176.511 193.699C176.572 193.761 176.655 193.797 176.742 193.798Z", fill: "white" }),
        React.createElement("path", { d: "M205.861 192.05C205.926 192.051 205.989 192.032 206.044 191.996C206.098 191.961 206.14 191.91 206.166 191.85C206.191 191.791 206.198 191.725 206.186 191.661C206.174 191.597 206.143 191.539 206.098 191.492C206.052 191.446 205.994 191.415 205.93 191.401C205.867 191.388 205.801 191.394 205.741 191.418C205.681 191.443 205.629 191.484 205.593 191.538C205.556 191.591 205.537 191.655 205.536 191.72C205.535 191.763 205.543 191.806 205.559 191.846C205.575 191.886 205.599 191.922 205.629 191.953C205.66 191.984 205.696 192.008 205.735 192.025C205.775 192.041 205.818 192.05 205.861 192.05Z", fill: "white" }),
        React.createElement("path", { d: "M214.444 187.436C214.524 187.436 214.602 187.413 214.668 187.369C214.734 187.324 214.786 187.261 214.817 187.188C214.847 187.114 214.855 187.033 214.839 186.955C214.824 186.877 214.786 186.805 214.729 186.749C214.673 186.692 214.601 186.654 214.523 186.639C214.445 186.623 214.364 186.631 214.29 186.662C214.217 186.692 214.154 186.744 214.11 186.81C214.065 186.876 214.042 186.954 214.042 187.034C214.042 187.14 214.084 187.243 214.16 187.318C214.235 187.394 214.338 187.436 214.444 187.436Z", fill: "white" }),
        React.createElement("path", { d: "M206.111 181.667C206.14 181.671 206.169 181.668 206.198 181.66C206.226 181.652 206.252 181.638 206.275 181.62C206.297 181.602 206.316 181.58 206.331 181.554C206.345 181.529 206.354 181.5 206.357 181.471C206.36 181.442 206.358 181.413 206.35 181.385C206.342 181.357 206.328 181.331 206.31 181.308C206.292 181.285 206.269 181.266 206.244 181.252C206.218 181.238 206.19 181.229 206.161 181.226H206.111C206.057 181.232 206.007 181.258 205.97 181.298C205.934 181.339 205.914 181.392 205.914 181.446C205.914 181.501 205.934 181.554 205.97 181.595C206.007 181.635 206.057 181.661 206.111 181.667Z", fill: "white" }),
        React.createElement("path", { d: "M179.622 196.237C179.651 196.237 179.68 196.232 179.706 196.221C179.733 196.21 179.758 196.195 179.778 196.174C179.799 196.154 179.815 196.13 179.827 196.104C179.838 196.077 179.844 196.049 179.844 196.02C179.844 195.961 179.821 195.905 179.779 195.863C179.738 195.821 179.681 195.798 179.622 195.798C179.593 195.798 179.564 195.803 179.537 195.814C179.51 195.825 179.486 195.841 179.465 195.861C179.445 195.882 179.428 195.906 179.417 195.933C179.406 195.959 179.4 195.988 179.4 196.017C179.4 196.076 179.423 196.131 179.464 196.172C179.505 196.214 179.561 196.237 179.619 196.237H179.622Z", fill: "white" }),
        React.createElement("path", { d: "M243.392 184.589C243.42 184.59 243.449 184.584 243.476 184.574C243.503 184.563 243.527 184.547 243.548 184.527C243.568 184.507 243.585 184.483 243.596 184.456C243.607 184.43 243.614 184.401 243.614 184.373C243.614 184.314 243.59 184.257 243.549 184.215C243.507 184.174 243.451 184.15 243.392 184.15C243.333 184.15 243.276 184.174 243.235 184.215C243.193 184.257 243.169 184.314 243.169 184.373C243.169 184.431 243.193 184.487 243.234 184.528C243.275 184.569 243.331 184.592 243.389 184.592L243.392 184.589Z", fill: "white" }),
        React.createElement("path", { d: "M152.381 187.75C152.53 187.75 152.676 187.706 152.8 187.623C152.925 187.54 153.021 187.422 153.079 187.284C153.136 187.146 153.151 186.994 153.122 186.847C153.092 186.701 153.02 186.566 152.915 186.461C152.809 186.355 152.675 186.283 152.528 186.254C152.381 186.225 152.229 186.24 152.091 186.297C151.953 186.354 151.835 186.451 151.752 186.575C151.669 186.699 151.625 186.845 151.625 186.995C151.625 187.195 151.705 187.387 151.846 187.529C151.988 187.671 152.18 187.75 152.381 187.75Z", fill: "white" }),
        React.createElement("path", { d: "M219.692 186.389C219.83 186.39 219.966 186.349 220.081 186.273C220.196 186.196 220.287 186.087 220.34 185.96C220.394 185.832 220.408 185.691 220.381 185.555C220.355 185.42 220.289 185.295 220.191 185.196C220.094 185.098 219.969 185.031 219.834 185.003C219.698 184.976 219.557 184.989 219.429 185.041C219.301 185.094 219.191 185.183 219.114 185.298C219.037 185.413 218.995 185.548 218.994 185.686C218.994 185.778 219.012 185.869 219.047 185.955C219.081 186.04 219.133 186.117 219.197 186.182C219.262 186.248 219.339 186.299 219.424 186.335C219.509 186.37 219.6 186.389 219.692 186.389Z", fill: "white" }),
        React.createElement("path", { d: "M82.4222 188.969C82.6205 188.97 82.8146 188.912 82.9798 188.802C83.145 188.692 83.2739 188.536 83.3503 188.353C83.4267 188.17 83.4472 187.968 83.409 187.774C83.3709 187.579 83.2758 187.4 83.136 187.26C82.9961 187.119 82.8177 187.023 82.6233 186.984C82.4289 186.944 82.2272 186.964 82.0438 187.039C81.8603 187.115 81.7034 187.243 81.5927 187.407C81.4821 187.572 81.4227 187.766 81.4222 187.964C81.4218 188.096 81.4474 188.226 81.4975 188.348C81.5475 188.47 81.6211 188.58 81.7139 188.674C81.8068 188.767 81.9171 188.841 82.0386 188.892C82.1602 188.943 82.2905 188.969 82.4222 188.969Z", fill: "white" }),
        React.createElement("path", { d: "M101.414 184.492C101.464 184.492 101.513 184.478 101.555 184.451C101.597 184.423 101.629 184.384 101.649 184.338C101.669 184.292 101.674 184.242 101.665 184.193C101.656 184.143 101.632 184.098 101.597 184.062C101.562 184.027 101.518 184.002 101.469 183.992C101.42 183.981 101.369 183.986 101.322 184.005C101.276 184.023 101.236 184.055 101.208 184.096C101.18 184.138 101.164 184.186 101.164 184.236C101.164 184.303 101.19 184.366 101.237 184.413C101.284 184.46 101.348 184.486 101.414 184.486V184.492Z", fill: "white" }),
        React.createElement("path", { d: "M104.325 187.403C104.374 187.403 104.423 187.389 104.464 187.361C104.505 187.334 104.537 187.295 104.556 187.249C104.575 187.203 104.58 187.153 104.57 187.105C104.56 187.056 104.537 187.011 104.502 186.977C104.467 186.942 104.422 186.918 104.374 186.908C104.325 186.898 104.275 186.903 104.229 186.922C104.184 186.941 104.145 186.973 104.117 187.014C104.09 187.056 104.075 187.104 104.075 187.153C104.075 187.22 104.101 187.283 104.148 187.33C104.195 187.377 104.259 187.403 104.325 187.403Z", fill: "white" }),
        React.createElement("path", { d: "M101.414 190.897C101.463 190.897 101.512 190.883 101.553 190.855C101.594 190.828 101.626 190.789 101.645 190.743C101.664 190.697 101.669 190.647 101.659 190.599C101.649 190.55 101.626 190.506 101.591 190.471C101.556 190.436 101.511 190.412 101.463 190.402C101.414 190.393 101.364 190.398 101.318 190.417C101.273 190.435 101.233 190.467 101.206 190.509C101.179 190.55 101.164 190.598 101.164 190.647C101.164 190.714 101.19 190.777 101.237 190.824C101.284 190.871 101.348 190.897 101.414 190.897Z", fill: "white" }),
        React.createElement("path", { d: "M81.0305 184.492C81.0805 184.492 81.1295 184.478 81.1714 184.451C81.2133 184.423 81.2461 184.384 81.2657 184.338C81.2854 184.292 81.2909 184.242 81.2817 184.193C81.2725 184.143 81.2489 184.098 81.214 184.062C81.179 184.027 81.1342 184.002 81.0853 183.992C81.0364 183.981 80.9855 183.986 80.9391 184.005C80.8927 184.023 80.8529 184.055 80.8247 184.096C80.7964 184.138 80.7811 184.186 80.7805 184.236C80.7805 184.303 80.8069 184.366 80.8537 184.413C80.9006 184.46 80.9642 184.486 81.0305 184.486V184.492Z", fill: "white" }),
        React.createElement("path", { d: "M142.181 175.756C142.247 175.756 142.31 175.73 142.357 175.683C142.404 175.636 142.431 175.572 142.431 175.506C142.431 175.44 142.404 175.376 142.357 175.329C142.31 175.282 142.247 175.256 142.181 175.256C142.115 175.257 142.052 175.284 142.006 175.331C141.96 175.378 141.934 175.44 141.933 175.506C141.933 175.572 141.96 175.636 142.007 175.683C142.053 175.73 142.117 175.756 142.183 175.756H142.181Z", fill: "white" }),
        React.createElement("path", { d: "M147.419 186.239C147.469 186.239 147.518 186.225 147.56 186.198C147.602 186.171 147.635 186.131 147.655 186.085C147.674 186.039 147.68 185.989 147.671 185.94C147.661 185.89 147.638 185.845 147.603 185.809C147.568 185.774 147.523 185.749 147.474 185.739C147.425 185.729 147.374 185.733 147.328 185.752C147.282 185.77 147.242 185.802 147.214 185.843C147.185 185.885 147.17 185.933 147.169 185.983C147.169 186.05 147.196 186.114 147.242 186.162C147.289 186.21 147.353 186.237 147.419 186.239Z", fill: "white" }),
        React.createElement("path", { d: "M138.686 171.667C138.752 171.667 138.816 171.641 138.863 171.594C138.91 171.547 138.936 171.483 138.936 171.417C138.936 171.351 138.91 171.287 138.863 171.24C138.816 171.193 138.752 171.167 138.686 171.167C138.62 171.168 138.558 171.195 138.512 171.242C138.466 171.289 138.44 171.351 138.439 171.417C138.439 171.483 138.465 171.547 138.512 171.594C138.559 171.641 138.623 171.667 138.689 171.667H138.686Z", fill: "white" }),
        React.createElement("path", { d: "M135.772 174.883C135.822 174.884 135.871 174.87 135.913 174.842C135.955 174.815 135.988 174.776 136.007 174.73C136.027 174.684 136.033 174.633 136.023 174.584C136.014 174.535 135.991 174.49 135.956 174.454C135.921 174.418 135.876 174.394 135.827 174.383C135.778 174.373 135.727 174.378 135.681 174.396C135.634 174.415 135.595 174.447 135.566 174.488C135.538 174.529 135.523 174.578 135.522 174.628C135.522 174.661 135.528 174.693 135.54 174.724C135.552 174.754 135.571 174.782 135.593 174.806C135.616 174.829 135.644 174.848 135.674 174.861C135.704 174.874 135.737 174.88 135.769 174.881L135.772 174.883Z", fill: "white" }),
        React.createElement("path", { d: "M170.714 177.5C170.763 177.5 170.812 177.485 170.853 177.458C170.894 177.43 170.926 177.391 170.945 177.346C170.964 177.3 170.969 177.25 170.959 177.201C170.949 177.153 170.926 177.108 170.891 177.073C170.856 177.038 170.811 177.014 170.763 177.005C170.714 176.995 170.664 177 170.618 177.019C170.573 177.038 170.533 177.07 170.506 177.111C170.479 177.152 170.464 177.201 170.464 177.25C170.464 177.316 170.49 177.38 170.537 177.427C170.584 177.474 170.648 177.5 170.714 177.5Z", fill: "white" }),
        React.createElement("path", { d: "M167.803 180.706C167.852 180.706 167.901 180.691 167.942 180.664C167.983 180.636 168.015 180.597 168.034 180.552C168.053 180.506 168.058 180.456 168.048 180.407C168.038 180.359 168.014 180.314 167.98 180.279C167.945 180.244 167.9 180.221 167.852 180.211C167.803 180.201 167.753 180.206 167.707 180.225C167.661 180.244 167.622 180.276 167.595 180.317C167.567 180.358 167.553 180.407 167.553 180.456C167.553 180.522 167.579 180.586 167.626 180.633C167.673 180.68 167.736 180.706 167.803 180.706Z", fill: "white" }),
        React.createElement("path", { d: "M172.461 181.29C172.511 181.29 172.56 181.276 172.602 181.249C172.644 181.221 172.677 181.182 172.696 181.136C172.716 181.09 172.721 181.04 172.712 180.99C172.703 180.941 172.679 180.896 172.645 180.86C172.61 180.824 172.565 180.8 172.516 180.79C172.467 180.779 172.416 180.784 172.37 180.802C172.323 180.821 172.283 180.853 172.255 180.894C172.227 180.935 172.212 180.984 172.211 181.034C172.211 181.101 172.237 181.165 172.284 181.213C172.331 181.261 172.394 181.288 172.461 181.29Z", fill: "white" }),
        React.createElement("path", { d: "M163.728 184.784C163.778 184.784 163.827 184.769 163.868 184.741C163.91 184.714 163.942 184.674 163.961 184.628C163.98 184.582 163.985 184.531 163.976 184.482C163.966 184.433 163.942 184.388 163.906 184.352C163.871 184.317 163.826 184.293 163.777 184.283C163.728 184.273 163.677 184.278 163.631 184.298C163.585 184.317 163.545 184.349 163.518 184.391C163.49 184.432 163.475 184.481 163.475 184.531C163.475 184.598 163.502 184.662 163.549 184.71C163.596 184.757 163.661 184.784 163.728 184.784Z", fill: "white" }),
        React.createElement("path", { d: "M166.639 193.228C166.689 193.229 166.738 193.214 166.78 193.187C166.822 193.16 166.854 193.121 166.874 193.075C166.894 193.029 166.899 192.978 166.89 192.929C166.881 192.88 166.857 192.834 166.822 192.799C166.787 192.763 166.743 192.738 166.694 192.728C166.645 192.718 166.594 192.722 166.547 192.741C166.501 192.759 166.461 192.791 166.433 192.833C166.405 192.874 166.389 192.923 166.389 192.973C166.389 193.005 166.395 193.038 166.407 193.069C166.419 193.099 166.437 193.127 166.46 193.15C166.483 193.174 166.51 193.192 166.541 193.205C166.571 193.218 166.603 193.225 166.636 193.225L166.639 193.228Z", fill: "white" }),
        React.createElement("path", { d: "M161.981 192.645C162.03 192.645 162.078 192.63 162.119 192.602C162.161 192.575 162.193 192.536 162.212 192.49C162.23 192.445 162.235 192.394 162.226 192.346C162.216 192.297 162.192 192.253 162.157 192.218C162.122 192.183 162.078 192.159 162.029 192.149C161.981 192.14 161.931 192.145 161.885 192.164C161.839 192.182 161.8 192.215 161.773 192.256C161.745 192.297 161.731 192.345 161.731 192.395C161.731 192.461 161.757 192.524 161.804 192.571C161.851 192.618 161.914 192.645 161.981 192.645Z", fill: "white" }),
        React.createElement("path", { d: "M209.15 176.34C209.2 176.34 209.249 176.326 209.291 176.298C209.333 176.271 209.366 176.232 209.385 176.186C209.405 176.14 209.41 176.089 209.401 176.04C209.392 175.991 209.368 175.946 209.333 175.91C209.298 175.874 209.254 175.85 209.205 175.839C209.156 175.829 209.105 175.834 209.059 175.852C209.012 175.871 208.972 175.903 208.944 175.944C208.916 175.985 208.901 176.034 208.9 176.084C208.9 176.117 208.906 176.15 208.918 176.181C208.931 176.212 208.949 176.24 208.972 176.264C208.995 176.287 209.023 176.306 209.053 176.319C209.084 176.332 209.117 176.339 209.15 176.34Z", fill: "white" }),
        React.createElement("path", { d: "M227.778 187.987C227.828 187.988 227.877 187.973 227.919 187.946C227.96 187.919 227.993 187.879 228.013 187.834C228.033 187.788 228.038 187.737 228.029 187.688C228.02 187.638 227.996 187.593 227.961 187.557C227.926 187.522 227.881 187.497 227.833 187.487C227.784 187.477 227.733 187.481 227.686 187.5C227.64 187.518 227.6 187.55 227.572 187.591C227.544 187.633 227.528 187.681 227.528 187.731C227.528 187.798 227.554 187.861 227.601 187.908C227.648 187.955 227.711 187.981 227.778 187.981V187.987Z", fill: "white" }),
        React.createElement("path", { d: "M113.472 181.314C113.544 181.314 113.613 181.293 113.673 181.253C113.732 181.213 113.778 181.157 113.806 181.091C113.833 181.025 113.84 180.953 113.826 180.882C113.812 180.812 113.778 180.748 113.728 180.698C113.677 180.647 113.613 180.613 113.543 180.599C113.473 180.585 113.4 180.592 113.334 180.619C113.268 180.647 113.212 180.693 113.172 180.752C113.132 180.812 113.111 180.881 113.111 180.953C113.111 181 113.12 181.047 113.139 181.091C113.157 181.135 113.183 181.175 113.217 181.208C113.25 181.242 113.29 181.268 113.334 181.287C113.378 181.305 113.425 181.314 113.472 181.314Z", fill: "white" }),
        React.createElement("path", { d: "M79.5111 178.361C79.6457 178.361 79.7773 178.321 79.8892 178.246C80.0011 178.172 80.0884 178.065 80.1399 177.941C80.1914 177.817 80.2049 177.68 80.1786 177.548C80.1523 177.416 80.0875 177.295 79.9923 177.199C79.8972 177.104 79.7759 177.039 79.6439 177.013C79.5119 176.987 79.375 177 79.2507 177.052C79.1263 177.103 79.02 177.191 78.9453 177.302C78.8705 177.414 78.8306 177.546 78.8306 177.681C78.8306 177.861 78.9023 178.034 79.0299 178.162C79.1575 178.289 79.3306 178.361 79.5111 178.361Z", fill: "white" }),
        React.createElement("path", { d: "M133.586 172.795C133.772 172.795 133.953 172.741 134.108 172.638C134.263 172.535 134.384 172.389 134.455 172.218C134.527 172.046 134.546 171.858 134.51 171.675C134.475 171.493 134.386 171.326 134.255 171.194C134.124 171.062 133.957 170.972 133.775 170.936C133.593 170.899 133.404 170.917 133.232 170.987C133.06 171.058 132.913 171.178 132.81 171.332C132.706 171.486 132.651 171.667 132.65 171.853C132.65 172.102 132.748 172.341 132.924 172.517C133.099 172.693 133.337 172.793 133.586 172.795Z", fill: "white" }),
        React.createElement("path", { d: "M133.586 195.856C133.706 195.856 133.824 195.821 133.924 195.754C134.024 195.687 134.102 195.592 134.148 195.481C134.194 195.37 134.206 195.247 134.183 195.129C134.159 195.011 134.101 194.903 134.016 194.818C133.931 194.733 133.823 194.675 133.705 194.651C133.587 194.628 133.464 194.64 133.353 194.686C133.242 194.732 133.147 194.81 133.08 194.91C133.013 195.01 132.978 195.128 132.978 195.248C132.978 195.409 133.042 195.564 133.156 195.678C133.27 195.792 133.425 195.856 133.586 195.856Z", fill: "white" }),
        React.createElement("path", { d: "M84.8028 184.445C84.9539 184.445 85.1015 184.4 85.2272 184.316C85.3528 184.232 85.4507 184.113 85.5085 183.973C85.5663 183.834 85.5814 183.68 85.552 183.532C85.5225 183.384 85.4498 183.248 85.3429 183.141C85.2361 183.034 85.1 182.961 84.9518 182.932C84.8036 182.902 84.65 182.917 84.5104 182.975C84.3709 183.033 84.2515 183.131 84.1676 183.256C84.0837 183.382 84.0389 183.53 84.0389 183.681C84.0389 183.883 84.1194 184.078 84.2626 184.221C84.4059 184.364 84.6002 184.445 84.8028 184.445Z", fill: "white" }),
        React.createElement("path", { d: "M171.033 174.401C171.243 174.401 171.448 174.338 171.622 174.222C171.797 174.106 171.933 173.94 172.013 173.747C172.094 173.553 172.115 173.34 172.074 173.134C172.034 172.929 171.933 172.74 171.786 172.591C171.638 172.442 171.449 172.341 171.244 172.299C171.038 172.258 170.825 172.278 170.631 172.357C170.437 172.437 170.271 172.572 170.154 172.746C170.036 172.92 169.973 173.124 169.972 173.334C169.971 173.474 169.998 173.612 170.051 173.742C170.104 173.871 170.182 173.989 170.281 174.088C170.38 174.187 170.497 174.266 170.626 174.319C170.755 174.373 170.893 174.401 171.033 174.401Z", fill: "white" }),
        React.createElement("path", { d: "M205.975 188.959C206.185 188.959 206.39 188.897 206.565 188.78C206.739 188.664 206.875 188.498 206.955 188.304C207.036 188.11 207.057 187.897 207.016 187.691C206.975 187.485 206.874 187.296 206.725 187.148C206.577 186.999 206.388 186.898 206.182 186.857C205.976 186.816 205.763 186.837 205.569 186.918C205.375 186.998 205.209 187.134 205.093 187.309C204.976 187.483 204.914 187.688 204.914 187.898C204.914 188.179 205.026 188.449 205.225 188.648C205.424 188.847 205.694 188.959 205.975 188.959Z", fill: "white" }),
        React.createElement("path", { d: "M159.039 196.156C159.249 196.156 159.454 196.094 159.628 195.978C159.803 195.861 159.939 195.695 160.019 195.501C160.1 195.307 160.121 195.094 160.08 194.888C160.039 194.682 159.938 194.493 159.789 194.345C159.641 194.197 159.452 194.096 159.246 194.055C159.04 194.014 158.827 194.035 158.633 194.115C158.439 194.195 158.273 194.331 158.157 194.506C158.04 194.68 157.978 194.885 157.978 195.095C157.979 195.376 158.09 195.645 158.289 195.843C158.487 196.041 158.756 196.153 159.036 196.154L159.039 196.156Z", fill: "white" }),
        React.createElement("path", { d: "M92.1805 188.573C92.2943 188.573 92.4054 188.539 92.5 188.476C92.5945 188.413 92.6682 188.323 92.7118 188.218C92.7553 188.113 92.7667 187.997 92.7445 187.886C92.7223 187.774 92.6675 187.672 92.5871 187.591C92.5067 187.511 92.4042 187.456 92.2927 187.434C92.1812 187.412 92.0656 187.423 91.9605 187.467C91.8554 187.51 91.7656 187.584 91.7024 187.678C91.6392 187.773 91.6055 187.884 91.6055 187.998C91.6055 188.15 91.6658 188.295 91.7731 188.402C91.8804 188.51 92.026 188.57 92.1778 188.57L92.1805 188.573Z", fill: "white" }),
        React.createElement("path", { d: "M171.494 188.265C171.574 188.268 171.653 188.247 171.721 188.206C171.789 188.164 171.842 188.103 171.875 188.03C171.908 187.958 171.919 187.877 171.906 187.798C171.892 187.72 171.856 187.647 171.801 187.589C171.746 187.531 171.675 187.491 171.597 187.474C171.519 187.457 171.438 187.464 171.364 187.493C171.29 187.522 171.226 187.573 171.181 187.639C171.136 187.704 171.112 187.782 171.111 187.862C171.11 187.966 171.149 188.066 171.221 188.141C171.292 188.217 171.391 188.261 171.494 188.265Z", fill: "white" }),
        React.createElement("path", { d: "M108.356 177.711C108.435 177.711 108.512 177.688 108.578 177.644C108.644 177.6 108.695 177.537 108.725 177.464C108.755 177.391 108.763 177.311 108.748 177.233C108.732 177.156 108.694 177.084 108.638 177.028C108.582 176.972 108.511 176.934 108.434 176.919C108.356 176.903 108.276 176.911 108.202 176.942C108.129 176.972 108.067 177.023 108.023 177.089C107.979 177.155 107.956 177.232 107.956 177.311C107.956 177.417 107.998 177.519 108.073 177.594C108.148 177.669 108.249 177.711 108.356 177.711Z", fill: "white" }),
        React.createElement("path", { d: "M72.5389 182.953C72.618 182.954 72.6955 182.931 72.7616 182.887C72.8276 182.844 72.8793 182.782 72.9101 182.709C72.9409 182.636 72.9494 182.556 72.9345 182.478C72.9196 182.4 72.882 182.329 72.8264 182.272C72.7709 182.216 72.6999 182.178 72.6224 182.162C72.5449 182.146 72.4644 182.153 72.3911 182.183C72.3178 182.212 72.255 182.263 72.2106 182.329C72.1662 182.394 72.1422 182.471 72.1416 182.551C72.1409 182.603 72.1506 182.655 72.1703 182.704C72.1899 182.753 72.219 182.798 72.256 182.835C72.293 182.872 72.337 182.902 72.3856 182.923C72.4341 182.943 72.4862 182.953 72.5389 182.953Z", fill: "white" }),
        React.createElement("path", { d: "M149.981 178.909C150.213 178.909 150.44 178.84 150.633 178.711C150.827 178.581 150.977 178.398 151.066 178.183C151.155 177.969 151.178 177.732 151.133 177.504C151.088 177.276 150.976 177.067 150.811 176.903C150.647 176.738 150.438 176.627 150.21 176.581C149.982 176.536 149.746 176.559 149.531 176.648C149.316 176.737 149.133 176.888 149.004 177.081C148.874 177.274 148.806 177.501 148.806 177.734C148.806 178.044 148.929 178.343 149.149 178.562C149.369 178.782 149.667 178.906 149.978 178.906L149.981 178.909Z", fill: "white" }),
        React.createElement("path", { d: "M139.039 181.789C139.118 181.79 139.195 181.767 139.262 181.723C139.328 181.68 139.379 181.618 139.41 181.545C139.441 181.472 139.449 181.392 139.434 181.314C139.42 181.236 139.382 181.165 139.326 181.108C139.271 181.052 139.2 181.013 139.122 180.997C139.045 180.982 138.964 180.989 138.891 181.019C138.818 181.048 138.755 181.099 138.711 181.165C138.666 181.23 138.642 181.307 138.642 181.386C138.641 181.439 138.651 181.49 138.671 181.539C138.69 181.587 138.719 181.631 138.756 181.668C138.793 181.705 138.836 181.735 138.884 181.755C138.932 181.775 138.984 181.786 139.036 181.786L139.039 181.789Z", fill: "white" }),
        React.createElement("path", { d: "M124.3 182.831C124.349 182.831 124.398 182.816 124.439 182.789C124.48 182.761 124.512 182.722 124.531 182.677C124.55 182.631 124.555 182.581 124.545 182.532C124.536 182.484 124.512 182.439 124.477 182.404C124.442 182.369 124.397 182.346 124.349 182.336C124.3 182.326 124.25 182.331 124.204 182.35C124.159 182.369 124.12 182.401 124.092 182.442C124.065 182.483 124.05 182.532 124.05 182.581C124.05 182.647 124.076 182.711 124.123 182.758C124.17 182.805 124.234 182.831 124.3 182.831Z", fill: "white" }),
        React.createElement("path", { d: "M124.444 178.701C124.677 178.701 124.904 178.633 125.098 178.504C125.291 178.375 125.442 178.192 125.532 177.978C125.621 177.763 125.645 177.527 125.6 177.299C125.555 177.071 125.444 176.861 125.28 176.697C125.116 176.532 124.907 176.42 124.679 176.374C124.451 176.328 124.215 176.351 124 176.439C123.785 176.527 123.601 176.678 123.472 176.87C123.342 177.063 123.273 177.29 123.272 177.523C123.272 177.834 123.396 178.133 123.615 178.354C123.835 178.574 124.133 178.699 124.444 178.701Z", fill: "white" }),
        React.createElement("path", { d: "M131.844 187.445C131.924 187.445 132.001 187.422 132.067 187.379C132.133 187.335 132.185 187.273 132.216 187.2C132.246 187.127 132.255 187.047 132.24 186.969C132.225 186.892 132.188 186.82 132.132 186.764C132.076 186.707 132.005 186.669 131.928 186.653C131.85 186.637 131.77 186.644 131.697 186.674C131.623 186.704 131.561 186.755 131.516 186.82C131.472 186.885 131.448 186.963 131.447 187.042C131.447 187.094 131.457 187.146 131.477 187.195C131.496 187.244 131.526 187.288 131.562 187.325C131.599 187.363 131.643 187.393 131.692 187.413C131.74 187.433 131.792 187.444 131.844 187.445Z", fill: "white" }),
        React.createElement("path", { d: "M159.544 180.514C159.624 180.514 159.701 180.491 159.767 180.448C159.833 180.404 159.885 180.342 159.916 180.27C159.946 180.197 159.955 180.116 159.94 180.039C159.925 179.961 159.888 179.889 159.832 179.833C159.776 179.777 159.705 179.738 159.628 179.722C159.55 179.706 159.47 179.713 159.397 179.743C159.323 179.773 159.261 179.824 159.216 179.889C159.172 179.955 159.148 180.032 159.147 180.111C159.147 180.163 159.157 180.215 159.176 180.263C159.196 180.312 159.225 180.356 159.262 180.393C159.298 180.43 159.342 180.459 159.39 180.48C159.438 180.5 159.49 180.511 159.542 180.511L159.544 180.514Z", fill: "white" }),
        React.createElement("path", { d: "M236.111 186.036C236.19 186.037 236.268 186.014 236.334 185.97C236.4 185.927 236.452 185.865 236.482 185.792C236.513 185.719 236.522 185.639 236.507 185.561C236.492 185.483 236.454 185.412 236.399 185.355C236.343 185.299 236.272 185.261 236.195 185.245C236.117 185.229 236.037 185.236 235.963 185.266C235.89 185.295 235.827 185.346 235.783 185.412C235.738 185.477 235.714 185.554 235.714 185.634C235.713 185.686 235.723 185.738 235.743 185.787C235.762 185.836 235.791 185.881 235.828 185.918C235.865 185.955 235.909 185.985 235.958 186.006C236.006 186.026 236.058 186.036 236.111 186.036Z", fill: "white" }),
        React.createElement("path", { d: "M181.714 194C181.872 194 182.026 193.952 182.158 193.864C182.289 193.776 182.391 193.651 182.451 193.505C182.511 193.358 182.527 193.198 182.495 193.043C182.464 192.888 182.388 192.745 182.276 192.634C182.164 192.522 182.021 192.446 181.866 192.416C181.711 192.385 181.55 192.401 181.404 192.462C181.258 192.522 181.134 192.625 181.046 192.756C180.958 192.888 180.911 193.042 180.911 193.2C180.911 193.306 180.932 193.41 180.972 193.507C181.013 193.604 181.072 193.693 181.146 193.767C181.221 193.841 181.31 193.9 181.407 193.94C181.504 193.98 181.609 194.001 181.714 194Z", fill: "white" }),
        React.createElement("path", { d: "M197.897 185.589C197.967 185.589 198.035 185.569 198.093 185.53C198.151 185.491 198.196 185.436 198.223 185.372C198.25 185.307 198.257 185.236 198.243 185.168C198.23 185.099 198.196 185.036 198.147 184.987C198.097 184.938 198.034 184.904 197.966 184.891C197.898 184.877 197.827 184.884 197.762 184.911C197.698 184.937 197.643 184.983 197.604 185.041C197.565 185.099 197.544 185.167 197.544 185.237C197.544 185.33 197.582 185.42 197.648 185.486C197.714 185.552 197.804 185.589 197.897 185.589Z", fill: "white" }),
        React.createElement("path", { d: "M189.283 177.072C189.372 177.073 189.458 177.047 189.532 176.998C189.606 176.95 189.664 176.88 189.698 176.799C189.733 176.717 189.742 176.627 189.725 176.54C189.709 176.454 189.666 176.374 189.604 176.311C189.542 176.248 189.463 176.205 189.376 176.187C189.289 176.169 189.199 176.177 189.118 176.211C189.036 176.244 188.965 176.301 188.916 176.374C188.866 176.447 188.839 176.534 188.839 176.622C188.839 176.681 188.85 176.739 188.872 176.794C188.894 176.848 188.927 176.897 188.968 176.939C189.009 176.981 189.058 177.014 189.112 177.037C189.167 177.06 189.225 177.072 189.283 177.072Z", fill: "white" }),
        React.createElement("path", { d: "M167.444 175.617C167.533 175.618 167.62 175.592 167.693 175.543C167.767 175.495 167.825 175.425 167.859 175.344C167.894 175.262 167.903 175.172 167.886 175.085C167.87 174.998 167.828 174.919 167.765 174.856C167.703 174.793 167.624 174.75 167.537 174.732C167.451 174.714 167.361 174.722 167.279 174.756C167.197 174.789 167.127 174.846 167.077 174.919C167.027 174.992 167.001 175.079 167 175.167C167 175.226 167.011 175.284 167.033 175.338C167.055 175.393 167.088 175.442 167.129 175.484C167.17 175.526 167.219 175.559 167.274 175.582C167.328 175.605 167.386 175.617 167.444 175.617Z", fill: "white" }),
        React.createElement("path", { d: "M174.85 179.764C174.92 179.764 174.988 179.743 175.046 179.705C175.104 179.666 175.149 179.611 175.176 179.546C175.203 179.482 175.21 179.411 175.196 179.343C175.182 179.274 175.149 179.211 175.099 179.162C175.05 179.113 174.987 179.079 174.919 179.065C174.85 179.052 174.779 179.059 174.715 179.085C174.651 179.112 174.595 179.157 174.557 179.215C174.518 179.273 174.497 179.342 174.497 179.411C174.497 179.457 174.506 179.503 174.523 179.546C174.541 179.588 174.566 179.627 174.599 179.66C174.631 179.692 174.67 179.718 174.713 179.735C174.755 179.753 174.801 179.762 174.847 179.761L174.85 179.764Z", fill: "white" }),
        React.createElement("path", { d: "M182.419 185.589C182.489 185.59 182.558 185.57 182.616 185.531C182.674 185.493 182.72 185.438 182.747 185.374C182.774 185.31 182.782 185.239 182.769 185.17C182.756 185.102 182.723 185.039 182.674 184.989C182.625 184.939 182.562 184.905 182.494 184.891C182.425 184.877 182.354 184.883 182.29 184.91C182.225 184.936 182.17 184.981 182.13 185.038C182.091 185.096 182.07 185.164 182.069 185.234C182.069 185.28 182.078 185.326 182.095 185.369C182.113 185.412 182.138 185.451 182.171 185.484C182.203 185.517 182.242 185.543 182.285 185.561C182.327 185.579 182.373 185.589 182.419 185.589Z", fill: "white" }),
        React.createElement("path", { d: "M63.9416 199.756C63.6613 200.542 63.228 201.264 62.6666 201.881C62.5972 201.951 62.5305 202.023 62.4611 202.095C62.3916 202.167 62.3166 202.234 62.2416 202.301C61.3666 203.087 60.2855 203.609 59.125 203.803L59.0166 203.823L13.2111 211.601C11.4611 207.756 9.87683 203.814 8.45831 199.776L45.1944 193.539L45.4722 193.489L45.7861 193.437L55.9972 191.709L56.1194 191.689L56.9028 191.553L56.9916 191.537C57.2032 191.501 57.4164 191.476 57.6305 191.462C58.7683 191.387 59.9047 191.628 60.9139 192.159C61.3332 192.374 61.7249 192.639 62.0805 192.948L62.1472 193.006C63.08 193.828 63.7457 194.909 64.0585 196.112C64.3714 197.315 64.3171 198.584 63.9028 199.756H63.9416Z", fill: "#00B932" })));
});
NoDataFound.displayName = 'NoDataFoundSvg';
//# sourceMappingURL=no-data-found.js.map