import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { DownshiftProps, UseMultipleSelectionGetSelectedItemPropsOptions } from 'downshift';
import React from 'react';
import type { InputProps, SelectItem } from './select-component';
import type { SizeOptions } from 'carbon-react/esm/components/button/button.component';
interface SelectInputProps extends DownshiftProps<SelectItem> {
    borderColor?: string;
    closeIconClassName?: string;
    closeMenu: () => void;
    disabled?: boolean;
    disablePills?: boolean;
    displayNew?: boolean;
    error?: string;
    getSelectedItemProps?: (args: UseMultipleSelectionGetSelectedItemPropsOptions<SelectItem>) => any;
    handleBlur?: (event: React.FocusEvent<HTMLInputElement>) => void;
    handleSelectedItemRemove?: (selectedItem: SelectItem) => void;
    hasInputSearch?: boolean;
    hasLookupIcon?: boolean;
    helperText?: string;
    helperTextLink?: string;
    icon?: IconType;
    image?: SelectItem['image'];
    info?: string;
    inputId?: string;
    inputProps: InputProps;
    isLinkHelperText?: boolean;
    isMultiSelect?: boolean;
    label?: string;
    loading?: boolean;
    lookupButtonRef?: React.RefObject<HTMLButtonElement>;
    lookupIconId?: string;
    onClearFieldButtonClick?: () => void;
    onHelperTextLinkClick?: () => void;
    onLookupIconClick?: (event: React.MouseEvent<HTMLAnchorElement | HTMLButtonElement, MouseEvent>) => void;
    selectedRecords?: SelectItem[];
    size?: SizeOptions;
    testId?: string;
    toggleButtonProps: any;
    variant?: 'plain' | 'carbon';
    warning?: string;
    width?: string;
    wrapperProps: any;
}
export declare const SelectInput: React.ForwardRefExoticComponent<SelectInputProps & React.RefAttributes<HTMLInputElement>>;
export {};
//# sourceMappingURL=select-input.d.ts.map