import Link from 'carbon-react/esm/components/link';
import type { UseComboboxGetItemPropsOptions } from 'downshift';
import { type MutableRefObject } from 'react';
import React from 'react';
import type { SelectItem } from './select-component';
interface SelectDropDownProps {
    addSelectedItem: (item: SelectItem) => void;
    createTunnelLinkRef?: React.RefObject<HTMLButtonElement | HTMLAnchorElement>;
    createTunnelLinkText?: string;
    focusLookupButton: () => void;
    fullWidth?: boolean;
    getItemProps?: (options: UseComboboxGetItemPropsOptions<SelectItem>) => any;
    hasHelperTextField?: boolean;
    hasHighlightMatchText: boolean;
    hasLookupIcon?: boolean;
    highlightedIndex?: number;
    highlightFirstListItem: () => void;
    highlightLastListItem: () => void;
    inputId?: string;
    inputRef?: MutableRefObject<HTMLInputElement | null>;
    inputValue: string;
    isItemSelected?: (args: {
        id: string;
        value: string;
    }) => boolean;
    isLinkCreateNewText?: boolean;
    isMultiSelect?: boolean;
    isOpen: boolean;
    items: SelectItem[];
    linkElement?: React.ReactNode;
    loading: boolean;
    lookupLinkRef?: React.RefObject<HTMLButtonElement | HTMLAnchorElement>;
    maxHeight?: number;
    menuProps?: any;
    minLookupCharacters?: number;
    node?: any;
    onCreateNewItemLinkClick?: () => void;
    onLookupIconClick?: NonNullable<React.ComponentProps<typeof Link>['onClick']>;
    removeSelectedItem?: (item: SelectItem) => void;
    screenId?: string;
    shouldRenderOptionsAbove?: boolean;
    ulRef: React.RefObject<HTMLUListElement>;
    variant?: 'plain' | 'carbon';
}
export declare function SelectDropDown({ addSelectedItem, node, createTunnelLinkText, focusLookupButton, fullWidth, getItemProps, hasHelperTextField, hasHighlightMatchText, hasLookupIcon, highlightedIndex, inputRef, highlightFirstListItem, highlightLastListItem, linkElement, inputValue, isItemSelected, isLinkCreateNewText, isMultiSelect, isOpen, items, loading, lookupLinkRef, createTunnelLinkRef, maxHeight, menuProps, minLookupCharacters, onCreateNewItemLinkClick, onLookupIconClick, removeSelectedItem, screenId, shouldRenderOptionsAbove, ulRef: externalUlRef, variant, inputId, }: SelectDropDownProps): React.ReactElement;
export {};
//# sourceMappingURL=select-dropdown.d.ts.map