import { Checkbox as CarbonCheckbox } from 'carbon-react/esm/components/checkbox';
import { escape as lodashEscape, noop } from 'lodash';
import React from 'react';
import uid from 'uid';
import { Portrait } from '../portrait-component';
/**
 * The whole purpose of this wrapper component is to set the input's tabIndex="-1".
 * If that's not the case the element will be focusable and the select's focus will misbehave upon tabbing through the various fields.
 */
function CarbonCheckboxWrapper({ name, checked, onChange, }) {
    const id = React.useMemo(() => uid(16), []);
    React.useEffect(() => {
        const checkboxInput = document.getElementById(id);
        if (checkboxInput) {
            checkboxInput.tabIndex = -1;
        }
    }, [id]);
    return (React.createElement(CarbonCheckbox, { id: id, name: name, checked: checked, onChange: (e) => onChange(e.target.checked) }));
}
function Checkbox({ name, variant, checked, onChange, onClick = noop }) {
    return variant === 'carbon' ? (React.createElement(CarbonCheckboxWrapper, { name: name, checked: checked, onChange: onChange })) : (React.createElement("input", { type: "checkbox", name: name, checked: checked, onChange: (e) => onChange(e.target.checked), onClick: (e) => {
            e.stopPropagation();
            onClick(e);
        }, tabIndex: -1 }));
}
export function SelectDropDownItem({ addSelectedItem, fullWidth = false, isMultiSelect = false, isSelected, hasHighlightMatchText, item, itemProps, searchText, removeSelectedItem, style = {}, variant = 'carbon', }) {
    return (React.createElement("li", { ...itemProps, style: style, "data-pendoid": item.pendoId },
        React.createElement("div", { id: item.id, className: "e-ui-select-suggestion", "data-testid": "e-ui-select-suggestion" },
            isMultiSelect && (React.createElement(Checkbox, { name: String(item.value), checked: isSelected, onChange: () => {
                    if (isSelected && removeSelectedItem) {
                        removeSelectedItem(item);
                    }
                    else if (addSelectedItem) {
                        addSelectedItem(item);
                    }
                }, variant: variant })),
            item.image && (React.createElement("div", { className: "e-ui-select-suggestion-image" },
                React.createElement(Portrait, { image: item.image, placeholderValue: String(item.value), size: variant === 'carbon' ? 'S' : 'XS' }))),
            React.createElement("div", { className: "e-ui-select-suggestion-value-wrapper", "data-testid": "e-ui-select-suggestion-value-wrapper" },
                React.createElement("div", { className: "e-ui-select-suggestion-value", "data-testid": "e-ui-select-suggestion-value", style: { ...(!fullWidth && { flex: 1, textAlign: 'left' }) } },
                    React.createElement("p", { dangerouslySetInnerHTML: {
                            __html: getHighlightMatchText(lodashEscape(item.displayedAs || String(item.value)), isSelected, hasHighlightMatchText, searchText),
                        } })),
                item.helperText && (React.createElement("div", { className: "e-ui-select-suggestion-helper", "data-testid": "e-ui-select-suggestion-helper", style: { ...(!fullWidth && { textAlign: 'right' }), fontWeight: 'normal' } },
                    React.createElement("span", { dangerouslySetInnerHTML: {
                            __html: getHighlightMatchText(lodashEscape(item.helperText), isSelected, hasHighlightMatchText, searchText),
                        } })))))));
}
function getHighlightMatchText(text, isSelected, hasHighlightMatchText, searchText = '') {
    if (isSelected || !hasHighlightMatchText) {
        return text;
    }
    const regex = new RegExp(lodashEscape(searchText), 'gi');
    return text.replace(regex, (match) => `<span class="e-ui-select-highlight">${match}</span>`);
}
//# sourceMappingURL=select-dropdown-item.js.map