import React from 'react';
import Link from 'carbon-react/esm/components/link';
import { localize } from '../../../service/i18n-service';
import { getPageDefinitionFromState } from '../../../utils/state-utils';
import { getElementAccessStatus } from '../../../utils/access-utils';
import { useDeepEqualSelector } from '../../../utils/hooks/use-deep-equal-selector';
export const SelectCreateNewItem = React.forwardRef(({ node, createTunnelLinkText, onLinkKeyDown, onCreateNewItemLinkClick, screenId, position, }, ref) => {
    const createRight = useDeepEqualSelector(state => {
        if (!node || !screenId) {
            return null;
        }
        const pageDefinition = getPageDefinitionFromState(screenId, state);
        if (!pageDefinition) {
            return null;
        }
        return (getElementAccessStatus({
            accessBindings: pageDefinition.accessBindings,
            bind: '$create',
            elementProperties: {},
            contextNode: node,
            nodeTypes: state.nodeTypes,
            dataTypes: state.dataTypes,
        }) || null);
    });
    if (createRight !== 'authorized') {
        return null;
    }
    const style = {
        ...(position && position.top && { top: position.top }),
        ...(position && position.bottom && { bottom: position.bottom }),
    };
    return (React.createElement("div", { className: "e-ui-select-dropdown-create-new-item-link", "data-testid": "e-ui-select-dropdown-create-new-item-link", style: style },
        React.createElement(Link, { icon: "add", onClick: onCreateNewItemLinkClick, ref: ref, onKeyDown: onLinkKeyDown }, createTunnelLinkText ||
            localize('@sage/xtrem-ui/reference-create-new-item-link', 'Create new item'))));
});
SelectCreateNewItem.displayName = 'SelectCreateNewItem';
//# sourceMappingURL=select-create-new-item.js.map