import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { UseComboboxStateChangeTypes } from 'downshift';
import React from 'react';
import type { ImageValue } from '../../field/image/image-types';
import type { CollectionItem } from '../../types';
import type { SizeOptions } from 'carbon-react/esm/components/button/button.component';
export interface SelectItem {
    _id?: string;
    id: string;
    value: string;
    image?: ImageValue;
    helperText?: string;
    displayedAs?: string;
    __collectionItem?: CollectionItem;
    pendoId?: string;
}
export type InputProps = React.ComponentProps<'input'>;
export interface SelectProps {
    allowClearOnTab?: boolean;
    allowSelectOnTab?: boolean;
    autoSelect?: boolean;
    borderColor?: string;
    node?: any;
    defaultIsOpen?: boolean;
    disabled?: boolean;
    disablePills?: boolean;
    disableOpenOnFocus?: boolean;
    elementId?: string;
    error?: string;
    info?: string;
    shouldRenderOptionsAbove?: boolean;
    warning?: string;
    escapeBehavior?: 'native' | 'revert';
    hasInputSearch?: boolean;
    hasHighlightMatchText?: boolean;
    fullWidth?: boolean;
    getItems: (searchText: string) => Promise<SelectItem[]>;
    getNewItem?: (searchText: string) => SelectItem | undefined;
    hasLookupIcon?: boolean;
    hasClearFieldButton?: boolean;
    helperText?: string;
    helperTextLink?: string;
    icon?: IconType;
    initialInputValue?: string;
    initialSelectedItems?: SelectItem[];
    inputId?: string;
    inputWidth?: string;
    isSortedAlphabetically?: boolean;
    isDropdownDisabled?: boolean;
    isLinkCreateNewText?: boolean;
    isLinkHelperText?: boolean;
    isMultiSelect?: boolean;
    isSoundDisabled?: boolean;
    isHelperTextHidden?: boolean;
    label?: string;
    lookupButtonRef?: React.RefObject<HTMLButtonElement>;
    lookupIconId?: string;
    closeIconClassName?: string;
    minLookupCharacters?: number;
    /** This property indicates that the select ui component is used that does not support helper text in the items array */
    noHelperTextInItem?: boolean;
    autoSelectPolicy?: 'always' | 'onBlur';
    onAutoSelect?: (value: CollectionItem | undefined) => void;
    onBlur?: () => void;
    onChange?: (value: CollectionItem | undefined, isOrganicChange: boolean) => void;
    onSelected?: (value: SelectItem | null | undefined, selectionType: UseComboboxStateChangeTypes) => void;
    onHelperTextLinkClick?: () => void;
    onHighlightedChange?: (value?: SelectItem | null) => void;
    onInputChange?: (value: string, type?: UseComboboxStateChangeTypes) => void;
    onInputFocus?: () => void;
    onKeyDown?: (e: React.KeyboardEvent<HTMLInputElement>) => void;
    onLookupIconClick?: (event: React.MouseEvent<any>) => void;
    onSelectedItemsChange?: (selectedRecords: CollectionItem[]) => void;
    placeholder?: string;
    preventSelectionOnBlur?: boolean;
    readOnly?: boolean;
    refetchIfChanged?: any;
    screenId?: string;
    selectedItem?: SelectItem;
    selectedItems?: SelectItem[];
    shouldFilterItems?: boolean;
    size?: SizeOptions;
    testId?: string;
    variant?: 'plain' | 'carbon';
    isInTable?: boolean;
    createTunnelLinkText?: string;
    onCreateNewItemLinkClick?: () => void;
    onItemsFetched?: (args: {
        state: 'success';
        items: CollectionItem[];
    } | {
        state: 'error';
        error: string;
    } | {
        state: 'autoselect';
        item: CollectionItem | null;
    }) => void;
}
export declare const Select: React.ForwardRefExoticComponent<SelectProps & React.RefAttributes<HTMLInputElement>>;
//# sourceMappingURL=select-component.d.ts.map