import React from 'react';
import { formatDateToCurrentLocale } from '../../../service/i18n-service';
import { getRelativeDateDisplayValue } from '../../field/relative-date/relative-date-utils';
import CarbonTooltip from 'carbon-react/esm/components/tooltip';
import { isValidDatePropertyValue } from '@sage/xtrem-date-time';
export function RelativeDate({ value, scope }) {
    const isValid = isValidDatePropertyValue(value);
    return isValid ? (React.createElement(CarbonTooltip, { message: formatDateToCurrentLocale(value), position: "bottom" },
        React.createElement("span", { "data-testid": "e-relative-date-field-content" }, getRelativeDateDisplayValue(value, scope)))) : null;
}
//# sourceMappingURL=relative-date-component.js.map