import { GridRow } from '@sage/xtrem-ui-components';
import Button from 'carbon-react/esm/components/button';
import Heading from 'carbon-react/esm/components/heading';
import { camelCase, noop } from 'lodash';
import * as React from 'react';
import { localize } from '../../../service/i18n-service';
import { triggerHandledEvent } from '../../../utils/events';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { getFieldIndicatorStatus, getFieldTitle } from '../../field/carbon-helpers';
import { HelperText } from '../../field/carbon-utility-components';
import { NestedBlock } from '../nested-block';
import XtremActionPopover from '../xtrem-action-popover';
import { useDeepEqualSelector } from '../../../utils/hooks/use-deep-equal-selector';
export function Pod(props) {
    const nodeTypes = useDeepEqualSelector(s => s.nodeTypes);
    const { fieldProperties, browser, value, elementId, screenId } = props;
    const resolvedTitle = getFieldTitle(screenId, fieldProperties, props.value);
    const calculateDropdownActions = () => {
        if (!props.fieldProperties.dropdownActions) {
            return [];
        }
        let idx = 0;
        const mapFn = (a) => {
            const isDisabled = resolveByValue({
                fieldValue: undefined,
                propertyValue: a.isDisabled,
                rowValue: undefined,
                screenId: props.screenId,
                skipHexFormat: true,
            }) || false;
            const isHidden = resolveByValue({
                fieldValue: undefined,
                propertyValue: a.isHidden,
                rowValue: undefined,
                screenId: props.screenId,
                skipHexFormat: true,
            }) || false;
            const isMenuSeparator = resolveByValue({
                fieldValue: undefined,
                propertyValue: a.isMenuSeparator,
                rowValue: undefined,
                screenId: props.screenId,
                skipHexFormat: true,
            }) || false;
            const children = a.children ? a.children.map(mapFn) : [];
            idx += 1;
            const uniqueId = a.id || camelCase(a.title);
            const context = {
                id: a.id,
                uniqueId,
            };
            const testId = `e-pod-action e-pod-action--${uniqueId} e-action e-action--${uniqueId}`;
            return {
                childrenProp: children,
                icon: a.icon,
                isDisabled,
                isHidden,
                isMenuSeparator,
                key: `${idx}_${a.title}`,
                onClick: isMenuSeparator
                    ? noop
                    : () => {
                        if (isDisabled) {
                            return;
                        }
                        if (props.onTelemetryEvent) {
                            props.onTelemetryEvent(`podActionTriggered-${uniqueId}`, {
                                screenId: props.screenId,
                                elementId: props.elementId,
                                id: context.id,
                                uniqueId: context.uniqueId,
                            });
                        }
                        triggerHandledEvent(props.screenId, props.elementId, {
                            onClick: a.onClick,
                            onError: undefined,
                        });
                    },
                priority: idx,
                testId,
                title: a.title,
            };
        };
        return props.fieldProperties.dropdownActions.map(mapFn);
    };
    const [actionPopoverItems, setActionPopoverItems] = React.useState(calculateDropdownActions());
    const onActionPopoverOpen = () => {
        setActionPopoverItems(calculateDropdownActions());
    };
    const { info, warning } = getFieldIndicatorStatus(props);
    const nestedBlockProps = {
        actionPopoverItems,
        availableColumns: props.availableColumns,
        baseClassName: 'pod',
        browser,
        contextNode: fieldProperties.node,
        contextType: props.contextType,
        focusPosition: null,
        headerLabel: fieldProperties.headerLabel,
        info,
        isCloseIconDisplayed: fieldProperties.canRemove,
        isDisabled: props.isDisabled,
        isReadOnly: props.isReadOnly,
        item: { $containerId: elementId },
        nestedFields: fieldProperties.columns || [],
        nodeTypes,
        noMargin: true,
        onActionPopoverOpen,
        onBlockClick: props.onBlockClick,
        onBlockRemoved: props.onRemove,
        onChange: props.onChange,
        parentElementId: elementId,
        recordValue: value,
        screenId,
        title: resolvedTitle && !fieldProperties.isTitleHidden ? resolvedTitle : undefined,
        validationErrors: props.validationErrors,
        warning,
    };
    return (React.createElement("div", { ...props.baseAttributesDivWrapper },
        value ? (React.createElement(GridRow, { columns: props.availableColumns, gutter: 0, verticalMargin: 0, margin: 0 },
            React.createElement(NestedBlock, { ...nestedBlockProps }))) : (addNewPod({
            fieldProperties,
            screenId,
            value,
            onNewPod: props.onNewPod,
            isDisabled: props.isDisabled,
            onActionPopoverOpen,
            actionPopoverItems,
        })),
        props.fieldProperties.helperText && React.createElement(HelperText, { helperText: props.fieldProperties.helperText })));
}
const addNewPod = ({ fieldProperties, screenId, value, onNewPod, isDisabled, onActionPopoverOpen, actionPopoverItems, }) => {
    const isEditable = !fieldProperties.isDisabled && !fieldProperties.isReadOnly;
    return (React.createElement(React.Fragment, null,
        ((fieldProperties.title && !fieldProperties.isTitleHidden) ||
            (actionPopoverItems && actionPopoverItems.length > 0)) && (React.createElement("div", { className: "e-pod-header" },
            React.createElement("h3", { className: "e-pod-title", "data-testid": "e-pod-title" },
                !fieldProperties.isTitleHidden && (React.createElement("span", { className: "e-pod-title-text" }, getFieldTitle(screenId, fieldProperties, value))),
                actionPopoverItems && actionPopoverItems.length > 0 && (React.createElement(XtremActionPopover, { items: actionPopoverItems, onOpen: onActionPopoverOpen }))))),
        React.createElement(Heading, { "data-testid": "e-pod-placeholder-text", divider: false, margin: "auto", title: fieldProperties.placeholder || localize('@sage/xtrem-ui/pod-placeholder-text', 'No data to display') }),
        isEditable && (React.createElement("div", { className: "e-pod-add" },
            React.createElement(Button, { buttonType: "secondary", "data-testid": "e-pod-add-new", iconType: "plus", onClick: onNewPod, disabled: isDisabled, m: "0" }, fieldProperties.addButtonText ||
                localize('@sage/xtrem-ui/pod-collection-add-new', 'Add an item'))))));
};
//# sourceMappingURL=pod-component.js.map