import React from 'react';
import type { ValueOrCallbackWithFieldValue } from '../../utils/types';
import type { ValidationResult } from '../../service/screen-base-definition';
export interface NestedFieldErrorsExternalProps {
    screenId: string;
    elementId: string;
}
export interface NestedFieldErrorsProps extends NestedFieldErrorsExternalProps {
    validationErrors: ValidationResult[];
    value: any;
    fieldType: string;
    fieldTitle?: ValueOrCallbackWithFieldValue<any, string>;
}
export interface TableValidationError {
    fieldName: string;
    mainFieldName?: string;
    mainFieldValue: string;
    columnId?: string;
    columnName?: string;
    message: string;
    recordId: string;
    validationRule: string;
    level?: number;
}
interface NestedFieldErrorsState {
    isDialogOpen: boolean;
}
declare class NestedFieldErrors extends React.Component<NestedFieldErrorsProps, NestedFieldErrorsState> {
    getTitle: () => string;
    onRemainingErrorsClick: () => Promise<void>;
    onClick: () => Promise<void>;
    getErrorList: (limit?: number) => React.ReactNode;
    render(): React.ReactNode;
}
export declare const ConnectedNestedFieldErrors: import("react-redux").ConnectedComponent<typeof NestedFieldErrors, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<NestedFieldErrors> | undefined;
    screenId: string;
    elementId: string;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export {};
//# sourceMappingURL=nested-field-errors-component.d.ts.map