import * as React from 'react';
import IconButton from 'carbon-react/esm/components/icon-button';
import Icon from 'carbon-react/esm/components/icon';
import * as tokens from '@sage/design-tokens/js/base/common';
import { localize } from '../../../service/i18n-service';
function NavigationArrows({ hasNextRecord, hasPreviousRecord, onNextRecord, onPreviousRecord, }) {
    return (React.createElement("div", { className: "e-header-navigation-arrow-container", "data-testid": "e-header-navigation-arrow-container" },
        React.createElement(IconButton, { "aria-label": localize('@sage/xtrem-ui/previous-record', 'Previous record'), "data-testid": "e-header-navigation-arrow-previous", "data-pendoid": "headerPreviousRecord", onClick: () => onPreviousRecord(), disabled: !hasPreviousRecord },
            React.createElement(Icon, { type: "arrow_up", color: tokens.colorsYin090, tooltipMessage: localize('@sage/xtrem-ui/previous-record', 'Previous record') })),
        React.createElement(IconButton, { "aria-label": localize('@sage/xtrem-ui/next-record', 'Next record'), "data-testid": "e-header-navigation-arrow-next", "data-pendoid": "headerNextRecord", onClick: () => onNextRecord(), disabled: !hasNextRecord },
            React.createElement(Icon, { type: "arrow_down", color: tokens.colorsYin090, tooltipMessage: localize('@sage/xtrem-ui/next-record', 'Next record') }))));
}
export default NavigationArrows;
//# sourceMappingURL=navigation-arrows.js.map