import React from 'react';
import type { PropertyValueType } from '../../field/reference/reference-types';
import type { MobileTableProps } from '../../field/table/mobile-table-component';
import type { CollectionItem, ContainerWidth } from '../../types';
export interface UiMobileTableProps {
    areCardFieldTitlesDisplayed?: boolean;
    availableColumns?: number;
    canAddRecord?: boolean;
    canDragCard?: boolean;
    columns: MobileTableProps['fieldProperties']['columns'];
    dropdownActions?: MobileTableProps['fieldProperties']['dropdownActions'];
    elementId: string;
    fieldProperties: MobileTableProps['fieldProperties'];
    groupByField: PropertyValueType;
    hasMorePages: boolean;
    inlineActions?: MobileTableProps['fieldProperties']['inlineActions'];
    isDisabled: boolean;
    isFetchingNextPage?: boolean;
    isGreaterThanSmall: boolean;
    isLoading?: boolean;
    isNavigationPanel: boolean;
    isNestedGrid?: boolean;
    isUsingInfiniteScroll?: boolean;
    level?: number;
    onFetchNextPage: () => void;
    onKeyDown?: (event: React.KeyboardEvent<HTMLDivElement>) => void;
    onResetFilter?: () => void;
    onRowClick?: (item: any) => (_item: any, isModifierKeyPushed: boolean) => void;
    onRowSelected: (row: CollectionItem) => void;
    onScroll?: (event: React.SyntheticEvent<HTMLDivElement>) => void;
    recordWidth?: ContainerWidth;
    screenId: string;
    searchText?: string;
    valuesDisplayed: any[];
}
export declare function MobileTable(props: UiMobileTableProps): JSX.Element;
//# sourceMappingURL=mobile-table-component.d.ts.map