import Button from 'carbon-react/esm/components/button';
import React from 'react';
import { InsightsIcon } from './insights-icon';
import { useSelector } from 'react-redux';
import { getPageDefinitionFromState } from '../../utils/state-utils';
import { localize } from '../../service/i18n-service';
export function PageHeaderInsightsButton({ screenId }) {
    const insightCount = useSelector(s => getPageDefinitionFromState(screenId, s)?.insightCount ?? 0);
    const onButtonClick = React.useCallback(() => {
        window.GmsChatUi?.setDisplayState?.('popup-right');
        window.GmsChatUi?.navigateTo?.('insights');
    }, []);
    const singularInsightMessage = React.useMemo(() => localize('@sage/xtrem-ui/insight-singular', '1 insight'), []);
    const pluralInsightMessage = React.useMemo(() => localize('@sage/xtrem-ui/insight-plural', '{{insightCount}} insights', { insightCount }), [insightCount]);
    if (!insightCount) {
        return null;
    }
    return (React.createElement("div", { className: "e-header-insights" },
        React.createElement(Button, { buttonType: "gradient-white", size: "small", onClick: onButtonClick },
            React.createElement("span", { className: "e-header-insights-icon" },
                React.createElement(InsightsIcon, null)),
            insightCount === 1 ? singularInsightMessage : pluralInsightMessage)));
}
//# sourceMappingURL=insights-button.js.map