import type { ReactNode } from 'react';
import React from 'react';
import type { ValidationResult } from '../../../service/screen-base-definition';
import type { CarbonLinkEvent, ValueOrCallbackWithFieldValue } from '../../../utils/types';
import type { ScreenBase } from '../../../service/screen-base';
type StatusIconWithPopoverProps = {
    screenId: string;
    unFilterErrors?: Function;
    filterErrors?: Function;
    content: ReactNode;
    validationErrors: ValidationResult[];
    /** Indicate additional warning message, rendered as tooltip and blue border. */
    infoMessage?: ValueOrCallbackWithFieldValue<ScreenBase, string>;
    /** Indicate additional information, rendered as tooltip and orange border. */
    warningMessage?: ValueOrCallbackWithFieldValue<ScreenBase, string>;
};
type StatusIconWithPopoverState = {
    mode: Mode;
    isOpen: boolean;
};
type Mode = 'DEFAULT' | 'ERRORS';
declare class StatusIconWithPopover extends React.Component<StatusIconWithPopoverProps, StatusIconWithPopoverState> {
    private toolTipRef;
    private triggerButtonRef;
    private closeButtonRef;
    constructor(props: StatusIconWithPopoverProps);
    isVisible: () => boolean;
    getDisplayErrorsButton: () => HTMLButtonElement | null | undefined;
    close: () => void;
    open: (ev?: CarbonLinkEvent) => void;
    toggle: () => void;
    setDefaultMode: () => Promise<void>;
    setErrorsMode: () => Promise<void>;
    getFilterButton: () => React.ReactNode;
    render(): React.ReactNode;
}
export default StatusIconWithPopover;
//# sourceMappingURL=status-icon-with-popover.d.ts.map