import type { ReduxResponsive } from '../../../redux/state';
import type { Filter } from '../../../service/filter-service';
import type { StringFilter, RangeFilter, MultipleRangeFilter, EnumFilter } from '../../types';
import { GraphQLTypes } from '../../../types';
import type { ReferenceProperties } from '../../field/reference/reference-types';
import type { NestedFieldTypes } from '../../nested-fields';
import { type FiltrableType } from '@sage/xtrem-shared';
export interface FilterManagerField {
    type: NestedFieldTypes;
    properties: {
        bind?: string;
        canFilter?: boolean;
        title?: string;
        type: GraphQLTypes | null;
        valueField?: ReferenceProperties['valueField'];
        helperTextField?: ReferenceProperties['helperTextField'];
    };
}
export interface FilterManagerExternalProps {
    screenId: string;
    nestedFields: FilterManagerField[];
    handleCancel: () => void;
    handleSave: (filters: Filter<FiltrableType>[]) => void;
    initialFilters?: Filter[];
}
export interface FilterManagerProps extends FilterManagerExternalProps {
    browser?: ReduxResponsive;
}
type FilterDisplayNameType = StringFilter | RangeFilter | MultipleRangeFilter | EnumFilter;
export declare const getFilterDisplayName: (fieldId: string, nestedFields: FilterManagerField[], text: FilterDisplayNameType, filterValue: string, title?: string) => string;
export {};
//# sourceMappingURL=filter-manager.d.ts.map