import CarbonDecimal from 'carbon-react/esm/components/decimal';
import React from 'react';
import { connect } from 'react-redux';
export const UnconnectedDecimal = React.forwardRef(({ allowEmptyValue = true, fieldHelp = '', precision = 2, ...rest }, ref) => (React.createElement(CarbonDecimal, { ...rest, ref: ref, allowEmptyValue: allowEmptyValue, "data-testid": "e-ui-decimal-input", fieldHelp: fieldHelp, precision: precision, inputIcon: rest.inputIcon, onKeyDown: rest.onKeyDown })));
UnconnectedDecimal.displayName = 'DecimalComponent';
export const Decimal = connect((state, props) => {
    return { ...props, locale: state.applicationContext?.locale || 'en-US' };
}, null, null, { forwardRef: true })(UnconnectedDecimal);
//# sourceMappingURL=decimal-component.js.map