import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { DecimalProps, CustomEvent } from 'carbon-react/esm/components/decimal';
import React from 'react';
import type { CarbonStyleOverrides } from '../../types';
interface Props {
    allowEmptyValue?: boolean;
    disabled: boolean;
    fieldHelp?: string;
    inputIcon?: IconType;
    onChange: (event: CustomEvent) => void;
    onKeyDown?: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    precision?: DecimalProps['precision'];
    styleOverride?: CarbonStyleOverrides;
    validations?: any;
    value?: string;
}
interface InternalProps extends Props {
    locale: string;
}
export interface DecimalValueObject {
    rawValue: string;
    formattedValue: string;
}
export declare const UnconnectedDecimal: React.FC<InternalProps>;
export declare const Decimal: import("react-redux").ConnectedComponent<React.FC<InternalProps>, {
    allowEmptyValue?: boolean | undefined;
    disabled: boolean;
    fieldHelp?: string | undefined;
    inputIcon?: IconType | undefined;
    onChange: (event: CustomEvent) => void;
    onKeyDown?: ((event: React.KeyboardEvent<HTMLInputElement>) => void) | undefined;
    precision?: 0 | 1 | 2 | 10 | 11 | 3 | 4 | 6 | 8 | 12 | 14 | 7 | 9 | 5 | 13 | 15 | undefined;
    styleOverride?: CarbonStyleOverrides | undefined;
    validations?: any;
    value?: string | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export {};
//# sourceMappingURL=decimal-component.d.ts.map