import * as tokens from '@sage/design-tokens/js/base/common';
import { Checkbox } from 'carbon-react/esm/components/checkbox';
import Icon from 'carbon-react/esm/components/icon';
import IconButton from 'carbon-react/esm/components/icon-button';
import ProgressTracker from 'carbon-react/esm/components/progress-tracker';
import { get, isNil } from 'lodash';
import * as React from 'react';
import { ConnectedNestedFieldWrapper } from '../../../render/nested-field-wrapper';
import { localize } from '../../../service/i18n-service';
import { getNestedFieldElementId, normalizeUnderscoreBind } from '../../../utils/abstract-fields-utils';
import { getImagePlaceholderValue } from '../../../utils/nested-field-utils';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { cleanMetadataFromRecord, splitValueToMergedValue } from '../../../utils/transformers';
import ConnectedTableDropdownActions from '../table-shared/table-dropdown-actions/table-dropdown-actions';
import ConnectedTableInlineActions from '../table-shared/table-inline-actions';
export const getNestedValue = (value, bind) => {
    if (!(value instanceof Object) || !bind) {
        return null;
    }
    const accessor = normalizeUnderscoreBind(bind);
    const result = get(value, accessor, null);
    if (isNil(result)) {
        return null;
    }
    return result;
};
const isHidden = (screenId, value, field, fieldValue) => !!field &&
    !!resolveByValue({
        screenId,
        propertyValue: field.properties.isHidden,
        rowValue: splitValueToMergedValue(value),
        fieldValue,
        skipHexFormat: true,
    });
const renderCard = ({ areCardFieldTitlesDisplayed = false, canSelect, cardDefinition, contextType, dropdownActions, inlineActions, isClickIndicatorHidden, isDisabled, isNewItem, isSelected, onCardClick, onSelect, parentElementId, screenId, value, }) => {
    if (!value) {
        return null;
    }
    const _id = value._id;
    const level = value.__level || 0;
    const cleanValue = cleanMetadataFromRecord(value);
    const titleLineValueId = getNestedFieldElementId(cardDefinition.title);
    const titleRightValueId = getNestedFieldElementId(cardDefinition.titleRight);
    const line2ValueId = getNestedFieldElementId(cardDefinition.line2);
    const line2RightValueId = getNestedFieldElementId(cardDefinition.line2Right);
    const line3ValueId = getNestedFieldElementId(cardDefinition.line3);
    const line3RightValueId = getNestedFieldElementId(cardDefinition.line3Right);
    const line4ValueId = getNestedFieldElementId(cardDefinition.line4);
    const line4RightValueId = getNestedFieldElementId(cardDefinition.line4Right);
    const line5ValueId = getNestedFieldElementId(cardDefinition.line5);
    const line5RightValueId = getNestedFieldElementId(cardDefinition.line5Right);
    const imageValueId = getNestedFieldElementId(cardDefinition.image);
    const progressValueId = getNestedFieldElementId(cardDefinition.progressBar);
    const titleLineValue = getNestedValue(value, titleLineValueId);
    const titleRightValue = getNestedValue(value, titleRightValueId);
    const line2Value = getNestedValue(value, line2ValueId);
    const line2RightValue = getNestedValue(value, line2RightValueId);
    const line3Value = getNestedValue(value, line3ValueId);
    const line3RightValue = getNestedValue(value, line3RightValueId);
    const line4Value = getNestedValue(value, line4ValueId);
    const line4RightValue = getNestedValue(value, line4RightValueId);
    const line5Value = getNestedValue(value, line5ValueId);
    const line5RightValue = getNestedValue(value, line5RightValueId);
    const imageValue = getNestedValue(value, imageValueId);
    const progressValue = getNestedValue(value, progressValueId);
    const titleRightHidden = isHidden(screenId, value, cardDefinition.titleRight, titleRightValue);
    const line2Hidden = isHidden(screenId, value, cardDefinition.line2, line2Value);
    const line2RightHidden = isHidden(screenId, value, cardDefinition.line2Right, line2RightValue);
    const line3Hidden = isHidden(screenId, value, cardDefinition.line3, line3Value);
    const line3RightHidden = isHidden(screenId, value, cardDefinition.line3Right, line3RightValue);
    const line4Hidden = isHidden(screenId, value, cardDefinition.line4, line4Value);
    const line4RightHidden = isHidden(screenId, value, cardDefinition.line4Right, line4RightValue);
    const line5Hidden = isHidden(screenId, value, cardDefinition.line5, line5Value);
    const line5RightHidden = isHidden(screenId, value, cardDefinition.line5Right, line5RightValue);
    const imageHidden = isHidden(screenId, value, cardDefinition.image, imageValue);
    const progressHidden = isHidden(screenId, value, cardDefinition.progressBar, progressValue);
    const commonProperties = {
        _id,
        contextType,
        handlersArguments: {
            onClick: [_id, cleanValue],
            rowValue: splitValueToMergedValue(cleanValue),
        },
        screenId,
        parentElementId,
        setFieldValue: () => Promise.resolve(),
        shouldRenderLabelInNestedReadOnlyMode: areCardFieldTitlesDisplayed,
    };
    const titleLineDisplayValue = isNewItem
        ? `${titleLineValue} (${localize('@sage/xtrem-ui/new', 'New')})`
        : titleLineValue;
    return (React.createElement(React.Fragment, null,
        React.createElement("div", { className: "e-card-body" },
            cardDefinition.image && !imageHidden && (React.createElement("span", { className: "e-card-image" },
                React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, columnDefinition: cardDefinition.image, columnName: imageValueId, columnProperties: {
                        ...cardDefinition.image.properties,
                        isReadOnly: true,
                        size: 'medium',
                        isTitleHidden: true,
                    }, value: imageValue, nestedReadOnlyField: true }))),
            React.createElement("div", { className: "e-card-content" },
                canSelect && (React.createElement("div", { className: "e-card-check" },
                    React.createElement(Checkbox, { checked: isSelected, value: "checked", onChange: () => onSelect?.(value), disabled: isDisabled }))),
                React.createElement("div", { className: "e-card-row-container" },
                    React.createElement("div", { className: "e-card-row e-card-row-line-title" },
                        React.createElement("span", { className: "e-card-title" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.title, columnName: titleLineValueId, columnProperties: cardDefinition.title.properties, value: titleLineDisplayValue })),
                        cardDefinition.titleRight && !titleRightHidden && (React.createElement("span", { className: "e-card-row-right" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.titleRight, columnName: titleRightValueId, columnProperties: {
                                    ...cardDefinition.titleRight.properties,
                                    isReadOnly: true,
                                }, value: titleRightValue })))),
                    React.createElement("div", { className: "e-card-row e-card-row-line-2" },
                        cardDefinition.line2 && !line2Hidden && (React.createElement("div", { className: "e-card-line-2" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line2, columnName: line2ValueId, columnProperties: {
                                    ...cardDefinition.line2.properties,
                                    isReadOnly: true,
                                }, value: line2Value }))),
                        cardDefinition.line2Right && !line2RightHidden && (React.createElement("span", { className: "e-card-row-right" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line2Right, columnName: line2RightValueId, columnProperties: {
                                    ...cardDefinition.line2Right.properties,
                                    isReadOnly: true,
                                }, value: line2RightValue })))),
                    React.createElement("div", { className: "e-card-row e-card-row-line-3" },
                        cardDefinition.line3 && !line3Hidden && (React.createElement("div", { className: "e-card-line-3" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line3, columnName: line3ValueId, columnProperties: {
                                    ...cardDefinition.line3.properties,
                                    isReadOnly: true,
                                }, value: line3Value }))),
                        cardDefinition.line3Right && !line3RightHidden && (React.createElement("span", { className: "e-card-row-right" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line3Right, columnName: line3RightValueId, columnProperties: {
                                    ...cardDefinition.line3Right.properties,
                                    isReadOnly: true,
                                }, value: line3RightValue })))),
                    React.createElement("div", { className: "e-card-row e-card-row-line-4" },
                        cardDefinition.line4 && !line4Hidden && (React.createElement("div", { className: "e-card-line-4" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line4, columnName: line4ValueId, columnProperties: {
                                    ...cardDefinition.line4.properties,
                                    isReadOnly: true,
                                }, value: line4Value }))),
                        cardDefinition.line4Right && !line4RightHidden && (React.createElement("span", { className: "e-card-row-right" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line4Right, columnName: line4RightValueId, columnProperties: {
                                    ...cardDefinition.line4Right.properties,
                                    isReadOnly: true,
                                }, value: line4RightValue })))),
                    React.createElement("div", { className: "e-card-row e-card-row-line-5" },
                        cardDefinition.line5 && !line5Hidden && (React.createElement("div", { className: "e-card-line-5" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line5, columnName: line5ValueId, columnProperties: {
                                    ...cardDefinition.line5.properties,
                                    isReadOnly: true,
                                }, value: line5Value }))),
                        cardDefinition.line5Right && !line5RightHidden && (React.createElement("span", { className: "e-card-row-right" },
                            React.createElement(ConnectedNestedFieldWrapper, { ...commonProperties, nestedReadOnlyField: true, columnDefinition: cardDefinition.line5Right, columnName: line5RightValueId, columnProperties: {
                                    ...cardDefinition.line5Right.properties,
                                    isReadOnly: true,
                                }, value: line5RightValue }))))),
                inlineActions && inlineActions.length > 0 && (React.createElement(ConnectedTableInlineActions, { screenId: screenId, fieldId: parentElementId, recordId: value._id, level: level, rowValue: value, actions: inlineActions })),
                dropdownActions && dropdownActions.length > 0 && (React.createElement(ConnectedTableDropdownActions, { screenId: screenId, fieldId: parentElementId, recordId: value._id, level: level, rowValue: value })),
                onCardClick && parentElementId !== '$navigationPanel' && !isClickIndicatorHidden && (React.createElement("div", { className: "e-card-row-chevron-container" },
                    React.createElement(IconButton, { "aria-label": localize('@sage/xtrem-ui/select-record', 'Select record'), "data-testid": "e-card-row-chevron-right", onClick: () => { } },
                        React.createElement(Icon, { type: "chevron_right", color: tokens.colorsYin090, tooltipMessage: localize('@sage/xtrem-ui/select-record', 'Select record') })))))),
        progressValueId && !progressHidden && cardDefinition.progressBar && (React.createElement("div", { className: !cardDefinition.progressBar.properties.areProgressLabelsHidden
                ? 'e-card-row-progress-bar-container'
                : 'e-card-row-progress-bar-container e-progress-bar-label-hidden' },
            React.createElement(ProgressTracker, { length: "100%", progress: progressValue || 0, currentProgressLabel: cardDefinition.progressBar.properties.areProgressLabelsHidden
                    ? undefined
                    : cardDefinition.progressBar.properties.currentProgressLabel, maxProgressLabel: cardDefinition.progressBar.properties.areProgressLabelsHidden
                    ? undefined
                    : cardDefinition.progressBar.properties.maxProgressLabel })))));
};
export const CardComponent = React.memo((props) => {
    const { areCardFieldTitlesDisplayed, buttonRef, canSelect, cardDefinition, contextType, dropdownActions, id, inlineActions, isClickIndicatorHidden, isDisabled, isInFocus, isNewItem, isSelected, onCardClick, onSelect, parentElementId, screenId, value, } = props;
    const wrapperClassName = ['e-card'];
    if (isSelected) {
        wrapperClassName.push('e-card-selected');
    }
    if (cardDefinition.image) {
        wrapperClassName.push('e-card-has-image');
    }
    if (contextType) {
        wrapperClassName.push(`e-context-${contextType}`);
    }
    // We need to set the tab index to -1 to prevent some items from attracting focus.
    const focusTabIndex = isInFocus ? 0 : -1;
    const tabIndex = isInFocus === undefined ? undefined : focusTabIndex;
    const onClickHandler = (event) => {
        if (event.target.type !== 'checkbox' && onCardClick && !isDisabled) {
            onCardClick(value, event.ctrlKey || event.metaKey);
        }
    };
    const sharedProps = {
        className: wrapperClassName.join(' '),
        id,
    };
    if (props.canDrag) {
        sharedProps.draggable = true;
        sharedProps.unselectable = 'on';
        sharedProps.onDragStart = (e) => {
            e.dataTransfer.setData('application/json', JSON.stringify(value));
        };
    }
    const wrapperElement = onCardClick ? (React.createElement("button", { ...sharedProps, onClick: onClickHandler, type: "button", ref: buttonRef, tabIndex: tabIndex, disabled: isDisabled }, renderCard({
        areCardFieldTitlesDisplayed,
        canSelect,
        cardDefinition,
        contextType,
        dropdownActions,
        inlineActions,
        isClickIndicatorHidden,
        isDisabled,
        isNewItem,
        isSelected,
        onCardClick,
        onSelect,
        parentElementId,
        screenId,
        value,
    }))) : (React.createElement("div", { ...sharedProps }, renderCard({
        areCardFieldTitlesDisplayed,
        canSelect,
        cardDefinition,
        contextType,
        dropdownActions,
        inlineActions,
        isClickIndicatorHidden,
        isDisabled,
        isNewItem,
        isSelected,
        onCardClick,
        onSelect,
        parentElementId,
        screenId,
        value,
    })));
    const titleTextValue = getImagePlaceholderValue(value, cardDefinition.title);
    const firstChar = titleTextValue ? String(titleTextValue).charAt(0).toUpperCase() : undefined;
    const separatorContent = firstChar && firstChar !== ' ' ? firstChar : '_';
    return (React.createElement("div", { "data-label": `${titleTextValue}`, "data-testid": "e-card" },
        props.shouldDisplayAlphabeticalDivider ? (React.createElement("div", { className: "e-horizontal-separator" }, separatorContent)) : null,
        wrapperElement));
});
CardComponent.displayName = 'CardComponent';
//# sourceMappingURL=card-component.js.map