import type { ClientNode } from '@sage/xtrem-client';
import * as React from 'react';
import type { ScreenBase } from '../../../service/screen-base';
import type { ContextType } from '../../../types';
import type { NestedField, NestedFieldTypes, NestedFieldTypesWithoutTechnical } from '../../nested-fields';
import type { NestedExtensionField } from '../../nested-fields-extensions';
import type { FieldKey } from '../../types';
import type { PortraitPlaceholderMode } from '../portrait-component';
import type { CollectionItemActionGroup, CollectionItemActionOrMenuSeparator, InlineCollectionItemAction } from '../table-shared/table-dropdown-actions/table-dropdown-action-types';
export declare const getNestedValue: (value: any, bind: string) => any;
export interface CardDefinition<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
    title: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    titleRight?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line2?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line2Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line3?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line3Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line4?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line4Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line5?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    line5Right?: NestedField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    image?: NestedField<CT, FieldKey.Image | FieldKey.Icon, NodeType>;
    progressBar?: NestedField<CT, FieldKey.Progress, NodeType>;
    [key: string]: NestedField<CT, NestedFieldTypes, NodeType> | undefined;
}
export interface CardExtensionDefinition<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
    title?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType>;
    titleRight?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line2?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line2Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line3?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line3Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line4?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line4Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line5?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    line5Right?: NestedExtensionField<CT, NestedFieldTypesWithoutTechnical, NodeType> | null;
    image?: NestedExtensionField<CT, FieldKey.Image | FieldKey.Icon, NodeType> | null;
    [key: string]: NestedExtensionField<CT, NestedFieldTypes, NodeType> | undefined | null;
}
export interface CardComponentProps<CT extends ScreenBase = ScreenBase, NodeType extends ClientNode = any> {
    areCardFieldTitlesDisplayed?: boolean;
    buttonRef?: React.RefObject<HTMLButtonElement>;
    canDrag?: boolean;
    canSelect?: boolean;
    cardDefinition: CardDefinition<CT, any>;
    contextType?: ContextType;
    dropdownActions?: Array<CollectionItemActionOrMenuSeparator<ScreenBase> | CollectionItemActionGroup<ScreenBase>>;
    id?: string;
    imagePlaceholderMode?: PortraitPlaceholderMode;
    imagePlaceholderValue?: string;
    inlineActions?: Array<InlineCollectionItemAction<ScreenBase>>;
    isClickIndicatorHidden?: boolean;
    isDisabled?: boolean;
    isInFocus?: boolean;
    isNewItem?: boolean;
    isSelected?: boolean;
    /** If the element is clickable then it is rendered into a button element, if not then into a div element */
    onCardClick?: (recordValue: any, isModifierKeyPushed: boolean) => void;
    onSelect?: (recordValue: any) => void;
    parentElementId: string;
    screenId: string;
    shouldDisplayAlphabeticalDivider?: boolean;
    value: NodeType;
}
export declare const CardComponent: React.MemoExoticComponent<(<CT extends ScreenBase = ScreenBase<any, any>, NodeType extends ClientNode = any>(props: CardComponentProps<CT, NodeType>) => React.JSX.Element)>;
//# sourceMappingURL=card-component.d.ts.map