import Button from 'carbon-react/esm/components/button';
import MultiActionButton from 'carbon-react/esm/components/multi-action-button';
import * as React from 'react';
import { calendarViews } from './calendar-body-types';
import { objectKeys } from '@sage/xtrem-shared';
export function CalendarViewSelector({ selectedView, onSelectView }) {
    return (React.createElement("div", { className: "e-calendar-view-select-container" },
        React.createElement(MultiActionButton, { className: "e-calendar-view-select", "data-testid": "e-calendar-view-select", text: calendarViews[selectedView](), subtext: "" }, objectKeys(calendarViews)
            .filter(k => k !== selectedView)
            .map((k) => (React.createElement(Button, { "data-testid": `e-calendar-view-select-item-${k}`, key: k, onClick: () => onSelectView(k), size: "small" }, calendarViews[k]()))))));
}
//# sourceMappingURL=calendar-view-selector.js.map