import type { EventContentArg } from '@fullcalendar/core';
import type { Locale } from '@sage/xtrem-shared';
import type { ValueOrCallbackWitRecordValue } from '../../../utils/types';
import type { PropertyValueType } from '../../field/reference/reference-types';
import type { CollectionItem } from '../../types';
import type { CalendarEvent } from './calendar-body-types';
export declare const getEventStyle: (screenId: string, eventProps: EventContentArg, record: any, hasClickEventListener?: boolean, cardColor?: ValueOrCallbackWitRecordValue<any, string>) => {
    eventClasses: string;
    style: React.CSSProperties;
};
export interface EventFormatterArgs {
    screenId: string;
    record: CollectionItem;
    startDateField: PropertyValueType;
    endDateField?: PropertyValueType;
    isEventMovable?: ValueOrCallbackWitRecordValue<any, boolean>;
}
export declare const eventFormatter: ({ screenId, record, startDateField, endDateField, isEventMovable, }: EventFormatterArgs) => CalendarEvent;
export declare const getCalendarLocale: ((userLocale: Locale) => string) & import("lodash").MemoizedFunction;
//# sourceMappingURL=calendar-body-utils.d.ts.map