import type { EventContentArg, EventInput } from '@fullcalendar/core';
import type { Dict } from '@sage/xtrem-shared';
import type { CollectionValue, GridLodable } from '../../../service/collection-data-service';
import type { ValueOrCallbackWitRecordValue } from '../../../utils/types';
import type { OptionsMenuItem } from '../../container/page/page-types';
import type { HasCalendarConfigurationOptions } from '../../field/traits';
import type { CardDefinition } from '../card/card-component';
export declare const calendarViews: Dict<() => string>;
export type CalendarView = keyof typeof calendarViews;
export interface CalendarEvent extends EventInput {
    allDay?: boolean;
    end: Date | string;
    start: Date | string;
    _id: string;
}
export interface CalendarBodyComponentProps extends HasCalendarConfigurationOptions<any> {
    cardColor?: ValueOrCallbackWitRecordValue<any, string>;
    elementId: string;
    eventCard: CardDefinition;
    fieldProperties: GridLodable;
    hasClickEventListener?: boolean;
    isGreaterThanSmall: boolean;
    onEventClick?: (_id: string, eventDetails: any, isModifierKeyPushed?: boolean) => void;
    screenId: string;
    selectedOptionsMenuItem?: OptionsMenuItem;
    selectedView?: CalendarView;
    value?: CollectionValue;
    filterModel?: any;
}
export interface CalendarEventCardProps {
    elementId: string;
    eventProps: EventContentArg;
    isMobileMonthlyView: boolean;
    selectedView: CalendarView;
    value?: CollectionValue;
    screenId: string;
    hasClickEventListener?: boolean;
    cardColor?: ValueOrCallbackWitRecordValue<any, string>;
    eventCard: CardDefinition;
}
//# sourceMappingURL=calendar-body-types.d.ts.map