import CarbonToast from 'carbon-react/esm/components/toast';
import * as React from 'react';
import { connect } from 'react-redux';
import * as xtremRedux from '../../redux';
import { PERMANENT_TOAST } from '../../service/toast-service';
import * as showdown from 'showdown';
import { escape as lodashEscape } from 'lodash';
const converter = new showdown.Converter();
export class ToastComponent extends React.Component {
    constructor(props) {
        super(props);
        this.onDismiss = () => {
            if (this.timeout) {
                clearTimeout(this.timeout);
            }
            this.setState({ open: false });
            // eslint-disable-next-line @typescript-eslint/no-implied-eval
            setTimeout(this.props.removeToast.bind(this), 1000);
        };
        this.state = { open: true };
    }
    componentDidMount() {
        if (this.props.toast.timeout !== PERMANENT_TOAST) {
            this.timeout = setTimeout(this.onDismiss, this.props.toast.timeout);
        }
    }
    render() {
        const { content, type, language = 'markdown' } = this.props.toast;
        return (React.createElement(CarbonToast, { variant: type, open: this.state.open, onDismiss: this.onDismiss, targetPortalId: "stacked", maxWidth: `${Math.min(550, window.innerWidth || 300)}px` },
            language === 'markdown' && (React.createElement("span", { "data-testid": `e-toast-content e-toast-content-type-${type}`, className: "e-toast-content", 
                // eslint-disable-next-line react/no-danger
                dangerouslySetInnerHTML: {
                    __html: converter.makeHtml(lodashEscape(content)),
                } })),
            language === 'jsx' && content));
    }
}
const mapStateToProps = (state, props) => {
    return {
        ...props,
        removeToast: xtremRedux.actions.actionStub,
    };
};
const mapDispatchToProps = (dispatch, props) => {
    return {
        removeToast: () => {
            dispatch(xtremRedux.actions.removeToast(props.toast.id));
        },
    };
};
export const ConnectedToastComponent = connect(mapStateToProps, mapDispatchToProps)(ToastComponent);
//# sourceMappingURL=toast-component.js.map