import { connect } from 'react-redux';
import React from 'react';
import { ConnectedTableSidebarBlock } from './table-sidebar-block';
import { resolveByValue } from '../../utils/resolve-value-utils';
import { objectKeys } from '@sage/xtrem-shared';
export function TableSidebarSection({ blocks, columns, elementId, level, recordId, screenId, }) {
    return (React.createElement("div", { className: "e-table-sidebar-section" }, Object.keys(blocks).map(blockKey => (React.createElement(ConnectedTableSidebarBlock, { block: blocks[blockKey], columns: columns, elementId: elementId, key: blockKey, level: level, recordId: recordId, screenId: screenId })))));
}
export const mapStateToProps = (state, props) => {
    const { screenId, elementId, level, recordId } = props;
    const screenDefinition = state.screenDefinitions[screenId];
    const value = screenDefinition.values[elementId];
    const recordValue = value.getRawRecord({
        id: recordId,
        cleanMetadata: true,
        isUncommitted: true,
        level,
    });
    const blocks = objectKeys(props.section.blocks)
        .filter(b => !resolveByValue({
        propertyValue: props.section.blocks[b].isHidden,
        rowValue: recordValue,
        fieldValue: recordValue?._id,
        screenId,
        skipHexFormat: true,
    }))
        .reduce((acc, blockId) => {
        acc[blockId] = props.section.blocks[blockId];
        return acc;
    }, {});
    return {
        ...props,
        blocks,
    };
};
export const ConnectedTableSidebarSection = connect(mapStateToProps)(TableSidebarSection);
//# sourceMappingURL=table-sidebar-section.js.map