import { connect } from 'react-redux';
import { getPageDefinitionFromState } from '../../utils/state-utils';
import React from 'react';
import { ContextType } from '../../types';
import ConnectedFieldWrapper from '../../render/field-wrapper';
export function TableSidebarNormalField({ fieldProperties, availableColumns, fieldId, screenId, }) {
    return (React.createElement(ConnectedFieldWrapper, { screenId: screenId, item: { $bind: fieldId, $isFullWidth: fieldProperties.isFullWidth }, availableColumns: availableColumns, contextType: ContextType.sidebar }));
}
export const mapStateToProps = (state, props) => {
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const fieldProperties = pageDefinition.metadata.uiComponentProperties[props.fieldId];
    return {
        ...props,
        fieldProperties,
    };
};
export const ConnectedTableSidebarNormalField = connect(mapStateToProps)(TableSidebarNormalField);
//# sourceMappingURL=table-sidebar-normal-field.js.map