import { connect } from 'react-redux';
import { getPageDefinitionFromState } from '../../utils/state-utils';
import React from 'react';
import { findColumnDefinitionByBind, normalizeUnderscoreBind } from '../../utils/abstract-fields-utils';
import { FieldKey } from '../types';
import { calculateFieldWidth } from '../../utils/responsive-utils';
import { GridColumn } from '@sage/xtrem-ui-components';
import { AsyncAggregateComponent } from '../field/aggregate/async-aggregate-component';
import { AsyncButtonComponent } from '../field/button/async-button-component';
import { AsyncCardComponent } from '../field/card/async-card-component';
import { AsyncCheckboxComponent } from '../field/checkbox/async-checkbox-component';
import { AsyncCountComponent } from '../field/count/async-count-component';
import { AsyncDateComponent } from '../field/date/async-date-component';
import { AsyncFilterSelectComponent } from '../field/filter-select/async-filter-select-component';
import { AsyncIconComponent } from '../field/icon/async-icon-component';
import { AsyncImageComponent } from '../field/image/async-image-component';
import { AsyncLabelComponent } from '../field/label/async-label-component';
import { AsyncLinkComponent } from '../field/link/async-link-component';
import { AsyncMultiReferenceComponent } from '../field/multi-reference/async-multi-reference-component';
import { AsyncNumericComponent } from '../field/numeric/async-numeric-component';
import { AsyncPodCollectionComponent } from '../field/pod-collection/async-pod-collection-component';
import { AsyncPodComponent } from '../field/pod/async-pod-component';
import { AsyncProgressComponent } from '../field/progress/async-progress-component';
import { AsyncReferenceComponent } from '../field/reference/async-reference-component';
import { AsyncRichTextComponent } from '../field/rich-text/async-rich-text-component';
import { AsyncStaticContentComponent } from '../field/static-content/async-static-content-component';
import { AsyncStepSequenceComponent } from '../field/step-sequence/async-step-sequence-component';
import { AsyncSwitchComponent } from '../field/switch/async-switch-component';
import { AsyncTableSummaryComponent } from '../field/table-summary/async-table-summary-component';
import { AsyncTextAreaComponent } from '../field/text-area/async-text-area-component';
import { AsyncTextComponent } from '../field/text/async-text-component';
import { AsyncToggleComponent } from '../field/toggle/async-toggle-component';
import { AsyncVisualProcessComponent } from '../field/visual-process/async-visual-process-component';
import { AsyncMessageComponent } from '../field/message/async-message-component';
import { AsyncFileComponent } from '../field/file/async-file-component';
import { AsyncSeparatorComponent } from '../field/separator/async-separator-component';
import { AsyncVitalPodComponent } from '../field/vital-pod/async-vital-pod-component';
import { get, isNil, noop } from 'lodash';
import { ConnectedSelectLikeFieldWrapper } from '../../render/select-like-field-wrapper';
import { ContextType } from '../../types';
import { withCollectionValueItemSubscription } from '../connected-collection';
import { AsyncDatetimeRangeComponent } from '../field/datetime-range/async-datetime-range-component';
import { AsyncDatetimeComponent } from '../field/datetime/async-datetime-component';
export function TableSidebarNestedField({ availableColumns, browser, elementId, fieldId, fieldProperties, fieldType, level, locale, onChange, recordValue, screenId, tableProperties, validationErrors, setFieldProperties, }) {
    const renderField = React.useCallback(() => {
        let contextNode;
        if (tableProperties.node) {
            contextNode = String(tableProperties.node);
        }
        else if (!isNil(level) && !isNil(tableProperties.levels)) {
            contextNode = tableProperties.levels[level].node;
        }
        const props = {
            value: get(recordValue, fieldId),
            fieldProperties,
            elementId: fieldId,
            contextType: ContextType.sidebar,
            locale,
            screenId,
            level,
            contextNode,
            isNested: true,
            parentElementId: elementId,
            recordContext: recordValue,
            onFocus: noop,
            setFieldProperties,
            shouldRenderLabelInNestedReadOnlyMode: true,
            validate: () => Promise.resolve([]),
            setFieldValue: async (bind, v) => {
                if (onChange) {
                    await onChange(bind, v);
                }
            },
            validationErrors: validationErrors?.filter(e => (e.columnId || e.recordId) === normalizeUnderscoreBind(fieldId)) || [],
            browser,
            removeNonNestedErrors: noop,
            handlersArguments: {
                rowValue: recordValue,
                onClick: [recordValue._id, recordValue],
                onChange: [recordValue._id, recordValue],
            },
        };
        // Shitty thing because switch case complains in sonarcloud about too many cases
        if (fieldType === FieldKey.Aggregate) {
            return React.createElement(AsyncAggregateComponent, { ...props });
        }
        if (fieldType === FieldKey.Button) {
            return React.createElement(AsyncButtonComponent, { ...props });
        }
        switch (fieldType) {
            case FieldKey.Card:
                return React.createElement(AsyncCardComponent, { ...props });
            case FieldKey.Checkbox:
                return React.createElement(AsyncCheckboxComponent, { ...props });
            case FieldKey.Count:
                return React.createElement(AsyncCountComponent, { ...props });
            case FieldKey.Date:
                return React.createElement(AsyncDateComponent, { ...props });
            case FieldKey.Datetime:
                return React.createElement(AsyncDatetimeComponent, { ...props });
            case FieldKey.DatetimeRange:
                return React.createElement(AsyncDatetimeRangeComponent, { ...props });
            case FieldKey.File:
                return React.createElement(AsyncFileComponent, { ...props });
            case FieldKey.FilterSelect:
                return React.createElement(AsyncFilterSelectComponent, { ...props, contextNode: contextNode });
            case FieldKey.Icon:
                return React.createElement(AsyncIconComponent, { ...props });
            case FieldKey.Image:
                return React.createElement(AsyncImageComponent, { ...props });
            case FieldKey.Label:
                return React.createElement(AsyncLabelComponent, { ...props });
            case FieldKey.Link:
                return React.createElement(AsyncLinkComponent, { ...props });
            case FieldKey.Message:
                return React.createElement(AsyncMessageComponent, { ...props });
            case FieldKey.MultiReference:
                return React.createElement(AsyncMultiReferenceComponent, { ...props, contextNode: contextNode });
            case FieldKey.Numeric:
                return React.createElement(AsyncNumericComponent, { ...props });
            case FieldKey.Progress:
                return React.createElement(AsyncProgressComponent, { ...props });
            case FieldKey.Reference:
                return React.createElement(AsyncReferenceComponent, { ...props, contextNode: contextNode });
            case FieldKey.RichText:
                return React.createElement(AsyncRichTextComponent, { ...props });
            case FieldKey.PodCollection:
                return React.createElement(AsyncPodCollectionComponent, { ...props });
            case FieldKey.Separator:
                return React.createElement(AsyncSeparatorComponent, { ...props });
            case FieldKey.StaticContent:
                return React.createElement(AsyncStaticContentComponent, { ...props });
            case FieldKey.StepSequence:
                return React.createElement(AsyncStepSequenceComponent, { ...props });
            case FieldKey.Switch:
                return React.createElement(AsyncSwitchComponent, { ...props });
            case FieldKey.TableSummary:
                return React.createElement(AsyncTableSummaryComponent, { ...props });
            case FieldKey.Text:
                return React.createElement(AsyncTextComponent, { ...props });
            case FieldKey.TextArea:
                return React.createElement(AsyncTextAreaComponent, { ...props });
            case FieldKey.Toggle:
                return React.createElement(AsyncToggleComponent, { ...props });
            case FieldKey.VisualProcess:
                return React.createElement(AsyncVisualProcessComponent, { ...props });
            case FieldKey.VitalPod:
                return React.createElement(AsyncVitalPodComponent, { ...props });
            case FieldKey.Pod:
                return React.createElement(AsyncPodComponent, { ...props });
            case FieldKey.Select:
            case FieldKey.MultiDropdown:
            case FieldKey.DropdownList:
            case FieldKey.Radio:
                return React.createElement(ConnectedSelectLikeFieldWrapper, { ...props, fieldType: fieldType });
            default:
                return (React.createElement("div", null,
                    "Unhandled field:",
                    fieldType));
        }
    }, [
        browser,
        elementId,
        fieldId,
        fieldProperties,
        fieldType,
        level,
        locale,
        onChange,
        recordValue,
        screenId,
        tableProperties,
        validationErrors,
        setFieldProperties,
    ]);
    const columnSpan = React.useMemo(() => calculateFieldWidth(browser.is, fieldType, availableColumns, fieldProperties?.isFullWidth, fieldProperties?.width), [availableColumns, browser.is, fieldProperties?.isFullWidth, fieldProperties?.width, fieldType]);
    if (!recordValue) {
        return null;
    }
    return React.createElement(GridColumn, { columnSpan: columnSpan }, renderField());
}
export const mapStateToProps = (state, props) => {
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const tableProperties = pageDefinition?.metadata.uiComponentProperties[props.elementId];
    const fieldProperties = findColumnDefinitionByBind(props.columns || [], props.fieldId)?.properties;
    const shouldFetchDefault = fieldProperties?.fetchesDefaults;
    const fieldType = findColumnDefinitionByBind(props.columns || [], props.fieldId)?.type;
    const value = pageDefinition.values[props.elementId];
    return {
        ...props,
        value,
        tableProperties,
        browser: state.browser,
        fieldProperties,
        fieldType: fieldType,
        locale: state.applicationContext?.locale,
        nodeTypes: state.nodeTypes,
        isUncommitted: true,
        shouldFetchDefault,
    };
};
export const ConnectedTableSidebarNestedField = connect(mapStateToProps)(withCollectionValueItemSubscription(TableSidebarNestedField));
//# sourceMappingURL=table-sidebar-nested-field.js.map