import type * as xtremRedux from '../../redux';
import React from 'react';
import type { SidebarFieldBinding } from './table-sidebar-types';
import { FieldKey } from '../types';
import type { Dict, LocalizeLocale } from '@sage/xtrem-shared';
import type { ReduxResponsive } from '../../plugin';
import type { CollectionValue } from '../../service/collection-data-service';
import type { EditableFieldProperties } from '../editable-field-control-object';
import type { ValidationResult } from '../../service/screen-base-definition';
import type { FormattedNodeDetails } from '../../service/metadata-types';
import type { NestedGridDecoratorProperties, TableDecoratorProperties } from '../decorator-properties';
import type { NestedField } from '../nested-fields';
export interface TableSidebarNestedFieldExternalProps extends SidebarFieldBinding {
    availableColumns: number;
    screenId: string;
    elementId: string;
    recordId: string;
    level?: number;
    isUncommitted: boolean;
    columns: Array<NestedField<any, any>>;
}
export interface TableSidebarNestedFieldProps extends TableSidebarNestedFieldExternalProps {
    fieldProperties: EditableFieldProperties;
    setFieldProperties: (bind: string, fieldProperties: EditableFieldProperties) => void;
    browser: ReduxResponsive;
    fieldType: FieldKey;
    onChange?: (bind: string, value: any) => Promise<void>;
    nodeTypes: Dict<FormattedNodeDetails>;
    locale: LocalizeLocale;
    value: CollectionValue;
    recordValue: any;
    shouldFetchDefault: boolean;
    tableProperties: TableDecoratorProperties | NestedGridDecoratorProperties;
    validationErrors?: ValidationResult[];
}
export declare function TableSidebarNestedField({ availableColumns, browser, elementId, fieldId, fieldProperties, fieldType, level, locale, onChange, recordValue, screenId, tableProperties, validationErrors, setFieldProperties, }: TableSidebarNestedFieldProps): React.ReactElement | null;
export declare const mapStateToProps: (state: xtremRedux.XtremAppState, props: TableSidebarNestedFieldExternalProps) => Partial<TableSidebarNestedFieldProps>;
export declare const ConnectedTableSidebarNestedField: import("react-redux").ConnectedComponent<React.ComponentType<TableSidebarNestedFieldProps>, {
    availableColumns: number;
    screenId: string;
    elementId: string;
    recordId: string;
    level?: number | undefined;
    isUncommitted: boolean;
    columns: Array<NestedField<any, any>>;
    fieldId: string;
    isNested: boolean;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
} | {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<React.Component<TableSidebarNestedFieldProps, any, any>> | undefined;
    availableColumns: number;
    screenId: string;
    elementId: string;
    recordId: string;
    level?: number | undefined;
    isUncommitted: boolean;
    columns: Array<NestedField<any, any>>;
    fieldId: string;
    isNested: boolean;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=table-sidebar-nested-field.d.ts.map