/* eslint-disable react/jsx-props-no-spreading */
import React from 'react';
import Button from 'carbon-react/esm/components/button';
import { BusinessActionButtonWrapper } from '../container/footer/bussiness-action-button-wrapper';
import { localize } from '../../service/i18n-service';
import { useSelector } from 'react-redux';
import { isSidebarDirty } from '../../utils/state-utils';
function ApplyButton({ onConfirm, validationErrors, hasExternalErrors, }) {
    const applyLabel = localize('@sage/xtrem-ui/sidebar-apply-changes', 'Apply');
    return (React.createElement(BusinessActionButtonWrapper, { title: applyLabel, id: "apply-button" },
        React.createElement(Button, { "data-testid": "e-table-sidebar-confirm-button", buttonType: "primary", onClick: () => onConfirm(false), ml: "12px", disabled: validationErrors.length > 0 || hasExternalErrors }, applyLabel)));
}
function ApplyAndAddNewButton({ onConfirm, validationErrors, hasExternalErrors, }) {
    const isScreenLessThanM = useSelector(state => state.browser.lessThan.m);
    const applyAndAddNewLabel = isScreenLessThanM
        ? localize('@sage/xtrem-ui/sidebar-mobile-apply-changes-and-create-new', 'Apply & new')
        : localize('@sage/xtrem-ui/sidebar-apply-changes-and-create-new', 'Apply and add new');
    return (React.createElement(BusinessActionButtonWrapper, { title: applyAndAddNewLabel, id: "apply-and-add-new-button" },
        React.createElement(Button, { "data-testid": "e-table-sidebar-confirm-and-add-new-button", buttonType: "secondary", onClick: () => onConfirm(true), ml: 0, disabled: validationErrors.length > 0 || hasExternalErrors }, applyAndAddNewLabel)));
}
function AddNewButton({ onNewButton, validationErrors, hasExternalErrors, }) {
    const addNewLabel = localize('@sage/xtrem-ui/sidebar-add-new', 'Add new');
    return (React.createElement(BusinessActionButtonWrapper, { title: addNewLabel, id: "add-new-button" },
        React.createElement(Button, { "data-testid": "e-table-sidebar-add-new-button", buttonType: "primary", onClick: () => onNewButton(), ml: "12px", disabled: validationErrors.length > 0 || hasExternalErrors }, addNewLabel)));
}
/*
 * Cases to handle:
 * 1. New record + not dirty -> only cancel action
 * 2. New record + dirty -> cancel, apply, apply and add new
 * 3. Existing record + not dirty -> cancel, add new
 * 4. Existing record + dirty -> cancel, apply, apply and add new
 */
export function TableSidebarFooterButtons({ hasExternalErrors, isNewRecord = false, onConfirm, onNewButton, validationErrors, canAddNewLine, }) {
    const isContentDirty = useSelector(state => isSidebarDirty(state));
    const buttonProps = React.useMemo(() => ({
        onConfirm,
        validationErrors,
        hasExternalErrors,
        onNewButton,
    }), [onConfirm, validationErrors, hasExternalErrors, onNewButton]);
    if (!isNewRecord && !isContentDirty && canAddNewLine) {
        return React.createElement(AddNewButton, { ...buttonProps });
    }
    if (isContentDirty && canAddNewLine) {
        return (React.createElement(React.Fragment, null,
            React.createElement(ApplyAndAddNewButton, { ...buttonProps }),
            React.createElement(ApplyButton, { ...buttonProps })));
    }
    if (!canAddNewLine) {
        return React.createElement(ApplyButton, { ...buttonProps });
    }
    return null;
}
//# sourceMappingURL=table-sidebar-footer-buttons.js.map