import { connect } from 'react-redux';
import * as xtremRedux from '../../redux';
import { XtremTabs } from '../ui/tabs/xtrem-tabs';
import React from 'react';
import { ConnectedTableSidebarSection } from './table-sidebar-section';
import { TableSidebarCard } from './table-sidebar-card';
import { resolveByValue } from '../../utils/resolve-value-utils';
import { withCollectionValueItemSubscription } from '../connected-collection';
import { objectKeys } from '@sage/xtrem-shared';
import Form from 'carbon-react/esm/components/form';
import Button from 'carbon-react/esm/components/button';
import { localize } from '../../service/i18n-service';
import { getPageDefinitionFromState, getResolvedSidebarLayout, getSidebarNormalFields, getSidebarTableProperties, } from '../../utils/state-utils';
import Loader from 'carbon-react/esm/components/loader';
import { executeEventHandlerWithExternalHandler } from '../../utils/events';
import { xtremConsole } from '../../utils/console';
import { useDeepCompareEffect } from '@sage/xtrem-ui-components';
import { BusinessActionButtonWrapper } from '../container/footer/bussiness-action-button-wrapper';
import { TableSidebarFooterButtons } from './table-sidebar-footer-buttons';
export function TableSidebarBody({ canAddNewLine, cardDefinition, columns, elementId, hasExternalErrors, isHeaderCardHidden, isNewRecord, level, onCancel, onConfirm, onNewButton, recordId, recordValue, screenId, sidebarLayoutDefinition, validationErrors, value, }) {
    const sections = React.useMemo(() => objectKeys(sidebarLayoutDefinition).reduce((acc, currentKey) => {
        const sectionDefinition = sidebarLayoutDefinition[currentKey];
        const isHidden = (!!screenId &&
            resolveByValue({
                propertyValue: sectionDefinition.isHidden,
                rowValue: recordValue,
                fieldValue: recordId,
                screenId,
                skipHexFormat: true,
            })) ||
            false;
        if (isHidden) {
            return acc;
        }
        let errorMessage;
        objectKeys(sectionDefinition.blocks).some(blockKey => {
            const fields = sectionDefinition.blocks[blockKey].fields;
            // Find if inside validation errors columnId match with some of the fields array and return that validationError
            const validationError = validationErrors.find(error => fields && fields.includes(error.columnId));
            if (validationError?.message) {
                errorMessage = validationError?.message;
                return true;
            }
            return false;
        });
        acc.push({ id: currentKey, title: sectionDefinition.title, validationMessage: errorMessage });
        return acc;
    }, []), [recordId, recordValue, screenId, sidebarLayoutDefinition, validationErrors]);
    const [currentTab, setCurrentTab] = React.useState(sections[0]?.id || '');
    const [isSectionLoading, setSectionLoading] = React.useState(false);
    const activeEventHandler = React.useMemo(() => sidebarLayoutDefinition[currentTab].onActive, [currentTab, sidebarLayoutDefinition]);
    const onTabSelection = React.useCallback((tabId) => {
        setCurrentTab(tabId);
        if (sidebarLayoutDefinition[tabId].onActive) {
            setSectionLoading(true);
        }
    }, [sidebarLayoutDefinition]);
    useDeepCompareEffect(() => {
        const executeHandler = async () => {
            if (activeEventHandler) {
                try {
                    await executeEventHandlerWithExternalHandler({
                        elementId,
                        screenId,
                        eventHandler: activeEventHandler,
                        args: [recordId, recordValue],
                    });
                }
                catch (error) {
                    xtremConsole.error('Error executing event handler:', error);
                }
            }
            setSectionLoading(false);
        };
        if (activeEventHandler) {
            setSectionLoading(true);
        }
        executeHandler();
    }, [recordId, currentTab, elementId, screenId, recordValue]);
    const cancelLabel = localize('@sage/xtrem-ui/cancel', 'Cancel');
    if (!recordId) {
        return React.createElement(Loader, null);
    }
    return (React.createElement(Form, { onSubmit: (ev) => {
            ev.preventDefault();
        }, rightSideButtons: React.createElement(TableSidebarFooterButtons, { isNewRecord: isNewRecord, onConfirm: onConfirm, onNewButton: onNewButton, validationErrors: validationErrors, hasExternalErrors: hasExternalErrors, canAddNewLine: canAddNewLine }), leftSideButtons: React.createElement(BusinessActionButtonWrapper, { title: cancelLabel, id: "cancel-button" },
            React.createElement(Button, { "data-testid": "e-table-sidebar-cancel-button", buttonType: "tertiary", onClick: onCancel, ml: "24px" }, cancelLabel)) },
        React.createElement("div", { "data-testid": "e-table-sidebar", className: "e-table-sidebar" },
            React.createElement("div", { className: "e-table-sidebar-body" },
                !isHeaderCardHidden && (React.createElement(TableSidebarCard, { elementId: elementId, isUncommitted: true, recordValue: recordValue, screenId: screenId, value: value, cardDefinition: cardDefinition, level: level })),
                sections.length > 1 && (React.createElement(XtremTabs, { tabs: sections, selectedTabId: currentTab, onTabChange: onTabSelection, inSidebar: true })),
                isSectionLoading && (React.createElement("div", { className: "e-table-sidebar-section" },
                    React.createElement(Loader, { size: "large", mt: 10 }))),
                !isSectionLoading && (React.createElement(ConnectedTableSidebarSection, { columns: columns, elementId: elementId, level: level, recordId: recordId, screenId: screenId, section: sidebarLayoutDefinition[currentTab] }))))));
}
export const mapStateToProps = (state, props) => {
    const pageDefinition = getPageDefinitionFromState(props.screenId, state);
    const value = pageDefinition.values[props.elementId];
    const sidebarLayoutDefinition = getResolvedSidebarLayout({
        layout: props.sidebarDefinition.layout,
        elementId: props.elementId,
        nodeTypes: state.nodeTypes,
        level: props.level,
        screenDefinition: pageDefinition,
        value,
    });
    const tableProperties = getSidebarTableProperties({
        elementId: props.elementId,
        level: props.level,
        pageDefinition,
    });
    let hasExternalErrors = false;
    const validationErrors = Object.keys(pageDefinition.errors).filter(e => pageDefinition.errors[e].length > 0);
    if (validationErrors.length > 0) {
        const fields = getSidebarNormalFields(sidebarLayoutDefinition).map(field => field.id);
        hasExternalErrors = Boolean(validationErrors.find(field => fields.includes(field)));
    }
    return {
        canAddNewLine: tableProperties.canAddNewLine,
        cardDefinition: props.cardDefinition,
        hasExternalErrors,
        isHeaderCardHidden: props.sidebarDefinition.isHeaderCardHidden,
        isUncommitted: true,
        level: props.level,
        recordId: props.recordId,
        screenId: props.screenId,
        sidebarLayoutDefinition,
        value,
    };
};
export const mapDispatchToProps = (dispatch, props) => {
    return {
        onConfirm: (addNewRecord = false) => {
            return dispatch(xtremRedux.actions.confirmTableSidebar(props.dialogId, addNewRecord));
        },
        onNewButton: () => {
            return dispatch(xtremRedux.actions.sidebarNavigateToNewRecordWithoutSaving(props.dialogId));
        },
        onCancel: () => {
            dispatch(xtremRedux.actions.closeTableSidebar(props.dialogId));
        },
    };
};
export const ConnectedTableSidebarBody = connect(mapStateToProps, mapDispatchToProps)(withCollectionValueItemSubscription(TableSidebarBody));
//# sourceMappingURL=table-sidebar-body.js.map