import * as xtremRedux from '../../redux';
import React from 'react';
import type { CollectionValue } from '../../service/collection-data-service';
import { type Dict } from '@sage/xtrem-shared';
import type { SidebarDefinitionDecorator, SidebarSectionDefinition } from './table-sidebar-types';
import type { ValidationResult } from '../../service/screen-base-definition';
import type { CardDefinition } from '../ui/card/card-component';
import type { NestedField } from '../nested-fields';
export interface TableSidebarBodyExternalProps {
    cardDefinition?: CardDefinition;
    columns: Array<NestedField<any, any>>;
    dialogId: number;
    elementId: string;
    isNewRecord?: boolean;
    level?: number;
    recordId?: string;
    screenId: string;
    sidebarDefinition: SidebarDefinitionDecorator;
}
export interface TableSidebarBodyProps extends TableSidebarBodyExternalProps {
    canAddNewLine?: boolean;
    hasExternalErrors: boolean;
    isHeaderCardHidden?: boolean;
    isUncommitted: boolean;
    onCancel: () => void;
    onConfirm: (addNewRecord?: boolean) => Promise<void>;
    onNewButton: () => Promise<void>;
    recordValue?: any;
    sidebarLayoutDefinition: Dict<SidebarSectionDefinition>;
    validationErrors: ValidationResult[];
    value: CollectionValue;
}
export declare function TableSidebarBody({ canAddNewLine, cardDefinition, columns, elementId, hasExternalErrors, isHeaderCardHidden, isNewRecord, level, onCancel, onConfirm, onNewButton, recordId, recordValue, screenId, sidebarLayoutDefinition, validationErrors, value, }: TableSidebarBodyProps): React.ReactElement;
export declare const mapStateToProps: (state: xtremRedux.XtremAppState, props: TableSidebarBodyExternalProps) => Partial<TableSidebarBodyProps>;
export declare const mapDispatchToProps: (dispatch: xtremRedux.AppThunkDispatch, props: TableSidebarBodyProps) => Partial<TableSidebarBodyProps>;
export declare const ConnectedTableSidebarBody: import("react-redux").ConnectedComponent<React.ComponentType<TableSidebarBodyProps>, {
    cardDefinition?: CardDefinition | undefined;
    columns: Array<NestedField<any, any>>;
    dialogId: number;
    elementId: string;
    isNewRecord?: boolean | undefined;
    level?: number | undefined;
    recordId?: string | undefined;
    screenId: string;
    sidebarDefinition: SidebarDefinitionDecorator;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
} | {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<React.Component<TableSidebarBodyProps, any, any>> | undefined;
    cardDefinition?: CardDefinition | undefined;
    columns: Array<NestedField<any, any>>;
    dialogId: number;
    elementId: string;
    isNewRecord?: boolean | undefined;
    level?: number | undefined;
    recordId?: string | undefined;
    screenId: string;
    sidebarDefinition: SidebarDefinitionDecorator;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=table-sidebar-body.d.ts.map