import { connect } from 'react-redux';
import React from 'react';
import Typography from 'carbon-react/esm/components/typography';
import { calculateContainerWidth, getGutterSize } from '../../utils/responsive-utils';
import { GridRow } from '@sage/xtrem-ui-components';
import { AbstractUiControlObject } from '../abstract-ui-control-object';
import { convertDeepBindToPathNotNull } from '../../utils/nested-field-utils';
import { ConnectedTableSidebarNestedField } from './table-sidebar-nested-field';
import { ConnectedTableSidebarNormalField } from './table-sidebar-normal-field';
import { findColumnDefinitionByBind } from '../../utils/abstract-fields-utils';
import { FieldKey } from '../types';
const COLUMN_COUNT = 4;
export function TableSidebarBlock({ browser, columns, elementId, fields, level, recordId, screenId, title, }) {
    const computedWidth = calculateContainerWidth(browser.is, COLUMN_COUNT, 'extra-large');
    const gridGutter = getGutterSize(browser.is);
    const filteredFields = fields.filter((f) => {
        if (!f.isNested) {
            return true;
        }
        const fieldType = findColumnDefinitionByBind(columns || [], f.fieldId)?.type;
        if (!fieldType || fieldType === FieldKey.Technical) {
            return false;
        }
        return true;
    });
    return (React.createElement("div", { className: "e-table-sidebar-block" },
        title && (React.createElement(Typography, { variant: "h4", mb: "8px" }, title)),
        React.createElement(GridRow, { columns: computedWidth, gutter: gridGutter, margin: 0, verticalMargin: 0 }, filteredFields.map(f => f.isNested ? (React.createElement(ConnectedTableSidebarNestedField, { ...f, elementId: elementId, recordId: recordId, level: level, columns: columns, isUncommitted: true, screenId: screenId, key: `${convertDeepBindToPathNotNull(f.fieldId)}-${f.isNested ? 'nested' : 'main'}}`, availableColumns: COLUMN_COUNT })) : (React.createElement(ConnectedTableSidebarNormalField, { screenId: screenId, key: `${convertDeepBindToPathNotNull(f.fieldId)}-${f.isNested ? 'nested' : 'main'}}`, availableColumns: COLUMN_COUNT, fieldId: f.fieldId }))))));
}
export const mapStateToProps = (state, props) => {
    const fields = props.block.fields.map(f => {
        if (f instanceof AbstractUiControlObject) {
            return {
                isNested: false,
                fieldId: f.id,
            };
        }
        return {
            fieldId: convertDeepBindToPathNotNull(f),
            isNested: true,
        };
    });
    return {
        ...props,
        fields,
        browser: state.browser,
        title: props.block.title,
    };
};
export const ConnectedTableSidebarBlock = connect(mapStateToProps)(TableSidebarBlock);
//# sourceMappingURL=table-sidebar-block.js.map