import type * as xtremRedux from '../../redux';
import React from 'react';
import type { SidebarBlockDefinition, SidebarFieldBinding } from './table-sidebar-types';
import type { ReduxResponsive } from '../../redux/state';
import type { NestedField } from '../nested-fields';
export interface TableSidebarBlockExternalProps {
    block: SidebarBlockDefinition;
    columns: Array<NestedField<any, any>>;
    elementId: string;
    recordId: string;
    screenId: string;
    level?: number;
}
export interface TableSidebarBlockProps extends TableSidebarBlockExternalProps {
    browser: ReduxResponsive;
    fields: SidebarFieldBinding[];
    level?: number;
    recordId: string;
    screenId: string;
    title?: string;
}
export declare function TableSidebarBlock({ browser, columns, elementId, fields, level, recordId, screenId, title, }: TableSidebarBlockProps): React.ReactElement;
export declare const mapStateToProps: (state: xtremRedux.XtremAppState, props: TableSidebarBlockExternalProps) => TableSidebarBlockProps;
export declare const ConnectedTableSidebarBlock: import("react-redux").ConnectedComponent<typeof TableSidebarBlock, {
    block: SidebarBlockDefinition;
    columns: Array<NestedField<any, any>>;
    elementId: string;
    recordId: string;
    screenId: string;
    level?: number | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
//# sourceMappingURL=table-sidebar-block.d.ts.map