import * as React from 'react';
import * as ReactDom from 'react-dom';
import { subscribe, unsubscribe } from '../service/shortcut-service';
/* TODO: This component should be changed to no longer rely on ReactDom.findDomNode(...) as
 *       this may cause issues if we should ever migrate to function components.
 *
 *       From the react documentation:
 *       -----------------------------
 *       findDOMNode only works on mounted components (that is, components that have been placed
 *       in the DOM). If you try to call this on a component that has not been mounted yet (like
 *       calling findDOMNode() in render() on a component that has yet to be created) an exception
 *       will be thrown.
 *
 *       findDOMNode cannot be used on function components.
 */
export class Shortcut extends React.Component {
    constructor() {
        super(...arguments);
        this.keyId = null;
    }
    componentDidMount() {
        // eslint-disable-next-line react/no-find-dom-node
        const element = ReactDom.findDOMNode(this);
        const callback = () => {
            if (element && window.document) {
                const event = window.document.createEvent('MouseEvent');
                event.initEvent('click', true, true);
                element.dispatchEvent(event);
            }
        };
        this.keyId = subscribe(this.props.combination, callback);
    }
    componentWillUnmount() {
        unsubscribe(this.keyId);
    }
    render() {
        return this.props.children;
    }
}
//# sourceMappingURL=shortcut.js.map