/**
 * @packageDocumentation
 * @module root
 * */
import { getPageMetadata } from '../../service/page-metadata';
import { getTargetPrototype, standardExtensionDecoratorImplementation } from '../../utils/decorator-utils';
import { AbstractDecorator } from '../abstract-decorator';
import { ActionKey } from '../types';
import { PageActionControlObject } from './page-action-control-object';
class PageActionDecorator extends AbstractDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = PageActionControlObject;
    }
}
/**
 * Initializes the decorated member as a [PageAction]{@link PageActionControlObject} with the provided properties
 *
 * @param properties The properties that the [PageAction]{@link PageActionControlObject} will be initialized with
 */
export function pageAction(properties) {
    // eslint-disable-next-line func-names
    return function (target, name) {
        const targetPrototype = getTargetPrototype(target.constructor);
        const pageMetadata = getPageMetadata(targetPrototype, target);
        pageMetadata.pageActionThunks[name] = (nodeTypes, dataTypes) => {
            const controlObject = new PageActionDecorator(target.constructor.name.endsWith('Extension') ? targetPrototype.prototype : target, name, {
                pageMetadata,
                properties,
            }, ActionKey.PageAction, nodeTypes, dataTypes, {}).build().controlObject;
            return controlObject;
        };
    };
}
export function pageActionOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=page-action-decorator.js.map