/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../service/page-extension';
import type { ScreenBase } from '../../service/screen-base';
import type { ScreenExtension } from '../../types';
import type { ClickableOverrideDecoratorProperties } from '../../utils/decorator-utils';
import type { Clickable, ExtensionField, HasShortcuts } from '../field/traits';
import type { PageActionProperties } from './page-action-control-object';
import { PageActionControlObject } from './page-action-control-object';
export interface PageActionDecoratorProperties<CT extends ScreenBase = ScreenBase> extends Omit<PageActionProperties<CT>, '_controlObjectType'>, Clickable<CT>, ExtensionField<CT, PageActionControlObject<any>>, HasShortcuts {
}
/**
 * Initializes the decorated member as a [PageAction]{@link PageActionControlObject} with the provided properties
 *
 * @param properties The properties that the [PageAction]{@link PageActionControlObject} will be initialized with
 */
export declare function pageAction<CT extends ScreenExtension<CT>>(properties: PageActionDecoratorProperties<Extend<CT>>): (target: CT, name: string) => void;
export declare function pageActionOverride<CT extends ScreenExtension<CT>>(properties: ClickableOverrideDecoratorProperties<PageActionDecoratorProperties<Extend<CT>>, Extend<CT>>): (target: CT, name: string) => void;
//# sourceMappingURL=page-action-decorator.d.ts.map