var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { getUiComponentProperties as defaultGetUiComponentProperties, setUiComponentProperties as defaultSetUiComponentProperties, } from '../../service/transactions-service';
import { triggerHandledEvent } from '../../utils/events';
import { AbstractUiControlObject } from '../abstract-ui-control-object';
import { ControlObjectProperty } from '../property-decorators/control-object-property-decorator';
import { FieldControlObjectResolvedProperty } from '../property-decorators/control-object-resolved-property-decorator';
import { ActionKey } from '../types';
/**
 * Action that will be placed in the page header (i.e. business action)
 */
export class PageActionControlObject extends AbstractUiControlObject {
    static { this.defaultUiProperties = {
        ...AbstractUiControlObject.defaultUiProperties,
        isHidden: false,
        isMenuSeparator: false,
    }; }
    constructor({ screenId, elementId, getUiComponentProperties = defaultGetUiComponentProperties, setUiComponentProperties = defaultSetUiComponentProperties, insertBefore, insertAfter, }) {
        super(screenId, elementId, getUiComponentProperties, setUiComponentProperties, ActionKey.PageAction);
        this.insertBefore = insertBefore;
        this.insertAfter = insertAfter;
    }
    async execute(executeErrorHandlers = false, ...args) {
        const onClick = this.getUiComponentProperty('onClick');
        if (onClick) {
            if (executeErrorHandlers) {
                await triggerHandledEvent(this.screenId, this.elementId, {
                    onClick,
                    onError: this.getUiComponentProperty('onError') || undefined,
                }, ...args);
            }
            else {
                await triggerHandledEvent(this.screenId, this.elementId, {
                    onClick,
                    delegateErrorToCaller: true,
                }, ...args);
            }
        }
    }
}
__decorate([
    ControlObjectProperty()
    /** Additional text that will be displayed when mousing over the page action */
], PageActionControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Icon of the action */
], PageActionControlObject.prototype, "icon", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** Whether the action is displayed */
], PageActionControlObject.prototype, "isHidden", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** Whether the page action is loading or not. If loading, the button is disabled and a loader is displayed.
     * Only works if the action is used as a business action. Default to false
     * */
], PageActionControlObject.prototype, "isLoading", void 0);
__decorate([
    FieldControlObjectResolvedProperty()
    /** Whether the action is a menu separator */
], PageActionControlObject.prototype, "isMenuSeparator", void 0);
__decorate([
    ControlObjectProperty()
    /** Whether the action is displayed */
], PageActionControlObject.prototype, "buttonType", void 0);
//# sourceMappingURL=page-action-control-object.js.map