/**
 * @packageDocumentation
 * @module root
 * */
import type { ButtonProps } from 'carbon-react/esm/components/button';
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { ScreenBase } from '../../service/screen-base';
import type { ScreenExtension } from '../../types';
import type { ValueOrCallbackWithFieldValue } from '../../utils/types';
import type { UiComponentProperties } from '../abstract-ui-control-object';
import { AbstractUiControlObject } from '../abstract-ui-control-object';
import type { Clickable, HasHelperText, HasIcon, HasShortcuts } from '../field/traits';
import type { ControlObjectConstructorProps } from '../types';
import { ActionKey } from '../types';
export type PageActionButtonType = ButtonProps['buttonType'];
export interface PageActionProperties<CT extends ScreenBase = ScreenBase> extends UiComponentProperties<CT>, HasHelperText, Clickable<CT>, HasIcon, HasShortcuts {
    /** Type of button, according with Carbon's API. Can be primary, secondary or tertiary */
    buttonType?: PageActionButtonType;
    /** If set the action's icon and text are rendered in red. Optional, defaults to false. */
    isDestructive?: boolean;
    /** Whether the HTML element is hidden or not. Defaults to false */
    isHidden?: ValueOrCallbackWithFieldValue<CT, boolean>;
    /** If set, only the icon is displayed, the title is used as a tooltip */
    isIconButton?: boolean;
    /** Whether the page action is a menu separator or not. Default to false */
    isMenuSeparator?: boolean;
    /** Whether the page action is loading or not. If loading, the button is disabled and a loader is displayed.
     * Only works if the action is used as a business action. Default to false
     * */
    isLoading?: boolean;
}
export interface IPageAction<CT extends ScreenExtension<CT> = ScreenBase> {
    screenId: string;
    elementId: string;
    getUiComponentProperties?: (screenId: string, elementId: string) => PageActionProperties<CT>;
    setUiComponentProperties?: (screenId: string, elementId: string, state: PageActionProperties<CT>) => void;
    insertBefore?: (context: CT) => PageActionControlObject<CT>;
    insertAfter?: (context: CT) => PageActionControlObject<CT>;
}
/**
 * Action that will be placed in the page header (i.e. business action)
 */
export declare class PageActionControlObject<CT extends ScreenExtension<CT> = ScreenBase> extends AbstractUiControlObject<CT, PageActionProperties<CT>> {
    static readonly defaultUiProperties: Partial<PageActionProperties<any>>;
    insertBefore?: ControlObjectConstructorProps<ActionKey.PageAction>['insertBefore'];
    insertAfter?: ControlObjectConstructorProps<ActionKey.PageAction>['insertAfter'];
    constructor({ screenId, elementId, getUiComponentProperties, setUiComponentProperties, insertBefore, insertAfter, }: IPageAction<CT>);
    /** Additional text that will be displayed when mousing over the page action */
    helperText?: string;
    /** Icon of the action */
    icon?: IconType;
    /** Whether the action is displayed */
    isHidden?: boolean;
    /** Whether the page action is loading or not. If loading, the button is disabled and a loader is displayed.
     * Only works if the action is used as a business action. Default to false
     * */
    isLoading?: boolean;
    /** Whether the action is a menu separator */
    isMenuSeparator?: boolean;
    /** Whether the action is displayed */
    buttonType?: PageActionButtonType;
    execute(executeErrorHandlers?: boolean, ...args: any[]): Promise<void>;
}
//# sourceMappingURL=page-action-control-object.d.ts.map