/**
 * @packageDocumentation
 * @module root
 * */
import { AggregateControlObject, CheckboxControlObject, CountControlObject, DateControlObject, DatetimeControlObject, DatetimeRangeControlObject, DropdownListControlObject, DynamicSelectControlObject, FilterSelectControlObject, IconControlObject, ImageControlObject, LabelControlObject, LinkControlObject, MultiDropdownControlObject, MultiReferenceControlObject, NumericControlObject, ProgressControlObject, ReferenceControlObject, RelativeDateControlObject, SelectControlObject, SwitchControlObject, TextAreaControlObject, TextControlObject, } from './control-objects';
import { FieldKey } from './types';
export const allowedMainFieldTypes = [
    FieldKey.Checkbox,
    FieldKey.Count,
    FieldKey.Date,
    FieldKey.Datetime,
    FieldKey.DatetimeRange,
    FieldKey.DropdownList,
    FieldKey.Label,
    FieldKey.Link,
    FieldKey.Numeric,
    FieldKey.Progress,
    FieldKey.Select,
    FieldKey.Text,
];
export function isInstanceOf(argument, C) {
    return argument instanceof C;
}
export function isNestedTechnical(argument) {
    return argument.type === FieldKey.Technical;
}
export function withoutNestedTechnical(argument) {
    if (!argument) {
        return [];
    }
    return argument.filter(i => !isNestedTechnical(i));
}
export const getNestedFieldDefaultProperties = (defaultProperties, controlObjectType) => ({
    ...defaultProperties,
    canFilter: true,
    _controlObjectType: controlObjectType,
});
export const aggregate = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(AggregateControlObject.defaultUiProperties, FieldKey.Aggregate),
    properties: { ...properties, _controlObjectType: FieldKey.Aggregate },
    type: FieldKey.Aggregate,
});
export const checkbox = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(CheckboxControlObject.defaultUiProperties, FieldKey.Checkbox),
    properties: { ...properties, _controlObjectType: FieldKey.Checkbox },
    type: FieldKey.Checkbox,
});
export const count = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(CountControlObject.defaultUiProperties, FieldKey.Count),
    properties: { ...properties, _controlObjectType: FieldKey.Count },
    type: FieldKey.Count,
});
export const date = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(DateControlObject.defaultUiProperties, FieldKey.Date),
    properties: { ...properties, _controlObjectType: FieldKey.Date },
    type: FieldKey.Date,
});
export const datetime = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(DatetimeControlObject.defaultUiProperties, FieldKey.Datetime),
    properties: { ...properties, _controlObjectType: FieldKey.Datetime },
    type: FieldKey.Datetime,
});
export const datetimeRange = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(DatetimeRangeControlObject.defaultUiProperties, FieldKey.DatetimeRange),
    properties: { ...properties, _controlObjectType: FieldKey.DatetimeRange },
    type: FieldKey.DatetimeRange,
});
export const dynamicSelect = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(DynamicSelectControlObject.defaultUiProperties, FieldKey.DynamicSelect),
    properties: { ...properties, _controlObjectType: FieldKey.DynamicSelect },
    type: FieldKey.DynamicSelect,
});
export const dropdownList = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(DropdownListControlObject.defaultUiProperties, FieldKey.DropdownList),
    properties: { ...properties, _controlObjectType: FieldKey.DropdownList },
    type: FieldKey.DropdownList,
});
export const filterSelect = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(FilterSelectControlObject.defaultUiProperties, FieldKey.FilterSelect),
    properties: { ...properties, _controlObjectType: FieldKey.FilterSelect },
    type: FieldKey.FilterSelect,
});
export const icon = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(IconControlObject.defaultUiProperties, FieldKey.Icon),
    properties: { ...properties, _controlObjectType: FieldKey.Icon },
    type: FieldKey.Icon,
});
export const image = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(ImageControlObject.defaultUiProperties, FieldKey.Image),
    properties: { ...properties, _controlObjectType: FieldKey.Image },
    type: FieldKey.Image,
});
export const label = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(LabelControlObject.defaultUiProperties, FieldKey.Label),
    properties: { ...properties, _controlObjectType: FieldKey.Label },
    type: FieldKey.Label,
});
export const link = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(LinkControlObject.defaultUiProperties, FieldKey.Link),
    properties: { ...properties, _controlObjectType: FieldKey.Link },
    type: FieldKey.Link,
});
export const numeric = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(NumericControlObject.defaultUiProperties, FieldKey.Numeric),
    properties: { ...properties, _controlObjectType: FieldKey.Numeric },
    type: FieldKey.Numeric,
});
export const progress = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(ProgressControlObject.defaultUiProperties, FieldKey.Progress),
    properties: { ...properties, _controlObjectType: FieldKey.Progress },
    type: FieldKey.Progress,
});
export const reference = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(ReferenceControlObject.defaultUiProperties, FieldKey.Reference),
    properties: { ...properties, _controlObjectType: FieldKey.Reference },
    type: FieldKey.Reference,
});
export const relativeDate = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(RelativeDateControlObject.defaultUiProperties, FieldKey.RelativeDate),
    properties: { ...properties, _controlObjectType: FieldKey.RelativeDate },
    type: FieldKey.RelativeDate,
});
export const multiReference = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(MultiReferenceControlObject.defaultUiProperties, FieldKey.MultiReference),
    properties: { ...properties, _controlObjectType: FieldKey.MultiReference },
    type: FieldKey.MultiReference,
});
export const multiDropdown = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(MultiDropdownControlObject.defaultUiProperties, FieldKey.MultiDropdown),
    properties: { ...properties, _controlObjectType: FieldKey.MultiDropdown },
    type: FieldKey.MultiDropdown,
});
export const select = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(SelectControlObject.defaultUiProperties),
    properties: { ...properties, _controlObjectType: FieldKey.Select },
    type: FieldKey.Select,
});
const nestedSwitch = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(SwitchControlObject.defaultUiProperties, FieldKey.Switch),
    properties: { ...properties, _controlObjectType: FieldKey.Switch },
    type: FieldKey.Switch,
});
export { nestedSwitch as switch };
export const text = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(TextControlObject.defaultUiProperties, FieldKey.Text),
    properties: { ...properties, _controlObjectType: FieldKey.Text },
    type: FieldKey.Text,
});
export const textArea = (properties) => ({
    defaultUiProperties: getNestedFieldDefaultProperties(TextAreaControlObject.defaultUiProperties, FieldKey.TextArea),
    properties: { ...properties, _controlObjectType: FieldKey.TextArea },
    type: FieldKey.TextArea,
});
export const technical = (properties) => ({
    defaultUiProperties: { ...properties, _controlObjectType: FieldKey.Technical },
    properties: { ...properties, _controlObjectType: FieldKey.Technical },
    type: FieldKey.Technical,
});
//# sourceMappingURL=nested-fields.js.map