import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../service/page-extension';
import type { ScreenBase } from '../service/screen-base';
import type { ScreenExtension } from '../types/index';
import type { NestedFieldTypes } from './nested-fields';
import type { NestedAggregateProperties, NestedCheckboxProperties, NestedCountProperties, NestedDateProperties, NestedDropdownListProperties, NestedFilterSelectProperties, NestedIconProperties, NestedImageProperties, NestedLabelProperties, NestedLinkProperties, NestedMultiDropdownProperties, NestedMultiReferenceProperties, NestedNumericProperties, NestedProgressProperties, NestedReferenceProperties, NestedSelectProperties, NestedSwitchProperties, NestedTextAreaProperties, NestedTextProperties } from './nested-fields-properties';
import { FieldKey } from './types';
export interface NestedExtensionInsertBeforeProperties {
    insertBefore?: string;
    insertAfter?: string;
}
export interface NestedAggregateExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedAggregateProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedCheckboxExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedCheckboxProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedCountExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedCountProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedDateExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedDateProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedDropdownListExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedDropdownListProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedFilterSelectExtensionProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends NestedFilterSelectProperties<CT, C, R>, NestedExtensionInsertBeforeProperties {
}
export interface NestedIconExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedIconProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedImageExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedImageProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedLabelExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedLabelProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedLinkExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedLinkProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedNumericExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedNumericProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedMultiDropdownExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedMultiDropdownProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedMultiReferenceExtensionProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends NestedMultiReferenceProperties<CT, C, R>, NestedExtensionInsertBeforeProperties {
}
export interface NestedProgressExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedProgressProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedReferenceExtensionProperties<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> extends NestedReferenceProperties<CT, C, R>, NestedExtensionInsertBeforeProperties {
}
export interface NestedSelectExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedSelectProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedSwitchExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedSwitchProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedTextExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedTextProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedTextAreaExtensionProperties<CT extends ScreenBase, C extends ClientNode = any> extends NestedTextAreaProperties<CT, C>, NestedExtensionInsertBeforeProperties {
}
export interface NestedFieldsExtensionPropertiesMap<CT extends ScreenBase, C extends ClientNode = any, R extends ClientNode = any> {
    [FieldKey.Aggregate]: NestedAggregateExtensionProperties<CT, C>;
    [FieldKey.Checkbox]: NestedCheckboxExtensionProperties<CT, C>;
    [FieldKey.Count]: NestedCountExtensionProperties<CT, C>;
    [FieldKey.Date]: NestedDateExtensionProperties<CT, C>;
    [FieldKey.DropdownList]: NestedDropdownListExtensionProperties<CT, C>;
    [FieldKey.FilterSelect]: NestedFilterSelectExtensionProperties<CT, C, R>;
    [FieldKey.Icon]: NestedIconExtensionProperties<CT, C>;
    [FieldKey.Image]: NestedImageExtensionProperties<CT, C>;
    [FieldKey.Label]: NestedLabelExtensionProperties<CT, C>;
    [FieldKey.Link]: NestedLinkExtensionProperties<CT, C>;
    [FieldKey.Numeric]: NestedNumericExtensionProperties<CT, C>;
    [FieldKey.MultiDropdown]: NestedMultiDropdownExtensionProperties<CT, C>;
    [FieldKey.MultiReference]: NestedMultiReferenceExtensionProperties<CT, C, R>;
    [FieldKey.Numeric]: NestedNumericExtensionProperties<CT, C>;
    [FieldKey.Progress]: NestedProgressExtensionProperties<CT, C>;
    [FieldKey.Reference]: NestedReferenceExtensionProperties<CT, C, R>;
    [FieldKey.Select]: NestedSelectExtensionProperties<CT, C>;
    [FieldKey.Switch]: NestedSwitchExtensionProperties<CT, C>;
    [FieldKey.Text]: NestedTextExtensionProperties<CT, C>;
    [FieldKey.TextArea]: NestedTextAreaExtensionProperties<CT, C>;
}
export type NestedFieldsExtensionProperties<T extends NestedFieldTypes, CT extends ScreenBase = any, C extends ClientNode = any, R extends ClientNode = any> = {
    [K in keyof NestedFieldsExtensionPropertiesMap<CT, C, R>]: K extends T ? NestedFieldsExtensionPropertiesMap<CT, C, R>[K] : never;
}[keyof {
    [K in keyof NestedFieldsExtensionPropertiesMap<CT, C, R>]: K extends T ? NestedFieldsExtensionPropertiesMap<CT, C, R>[K] : never;
}];
export interface NestedExtensionField<CT extends ScreenExtension<CT>, T extends NestedFieldTypes, C extends ClientNode = any, R extends ClientNode = any> {
    defaultUiProperties: NestedFieldsExtensionProperties<T, Extend<CT>, C, R>;
    properties: NestedFieldsExtensionProperties<T, Extend<CT>, C, R>;
    type: T;
}
export declare const aggregate: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedAggregateExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Aggregate, NodeType>;
export declare const checkbox: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCheckboxExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Checkbox, NodeType>;
export declare const count: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedCountExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Count, NodeType>;
export declare const date: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDateExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Date, NodeType>;
export declare const dropdownList: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedDropdownListExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.DropdownList, NodeType>;
export declare const filterSelect: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedFilterSelectExtensionProperties<Extend<CT>, NodeType, R>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.FilterSelect, NodeType, R>;
export declare const icon: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedIconExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Icon, NodeType>;
export declare const image: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedImageExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Image, NodeType>;
export declare const label: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLabelExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Label, NodeType>;
export declare const link: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedLinkProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Link, NodeType>;
export declare const numeric: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedNumericExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Numeric, NodeType>;
export declare const multiDropdown: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedMultiDropdownExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.MultiDropdown, NodeType>;
export declare const multiReference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedMultiReferenceExtensionProperties<Extend<CT>, NodeType, R>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.MultiReference, NodeType, R>;
export declare const progress: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedProgressExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Progress, NodeType>;
export declare const reference: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any, R extends ClientNode = any>(properties: Omit<NestedReferenceExtensionProperties<Extend<CT>, NodeType, R>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Reference, NodeType, R>;
export declare const select: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSelectExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Select, NodeType>;
declare const nestedSwitch: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedSwitchExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Switch, NodeType>;
export { nestedSwitch as switch };
export declare const text: <CT extends ScreenExtension<CT> = any, NodeType extends ClientNode = any>(properties: Omit<NestedTextExtensionProperties<Extend<CT>, NodeType>, "_controlObjectType">) => NestedExtensionField<CT, FieldKey.Text, NodeType>;
//# sourceMappingURL=nested-fields-extensions.d.ts.map