import type { WorkflowVariable } from '@sage/xtrem-shared';
import type { Edge, EdgeChange, Node, XYPosition } from 'reactflow';
import type { DefaultDataType, EdgeData } from './workflow-types';
export declare const edgeStyle: Partial<Edge>;
export declare const removeTransientNodeDataProperties: (data: DefaultDataType) => DefaultDataType;
export declare const removeTransientNodeDataPropertiesFromNodes: (nodes: Node<DefaultDataType>[]) => Node<DefaultDataType>[];
export declare const removeTransientEdgeDataPropertiesFromEdges: (nodes: Edge[]) => Edge[];
export declare const changeEventHandler: (screenId: string, elementId: string) => () => Promise<void>;
/**
 * Retrieve all previous nodes in the workflow, following all paths back to the start node.
 */
export declare const usePreviousWorkflowNodes: (nodeId?: string, screenId?: string, elementId?: string, includeCurrent?: boolean) => Node<DefaultDataType>[];
export declare const useSubsequentWorkflowNodes: (nodeId?: string, screenId?: string, elementId?: string, includeCurrent?: boolean) => Node<DefaultDataType>[];
export declare const useSourceNode: (edgeId: string, screenId?: string, elementId?: string) => Node<DefaultDataType> | null;
export declare const hasEdgeConnectedToNode: (nodeId: string, edges: Edge[], sourceHandle?: string) => boolean;
export declare const useWorkflowNodeVariables: (nodeId?: string, screenId?: string, elementId?: string, includeCurrent?: boolean) => {
    inputVariables: WorkflowVariable[];
    oldRootPaths: string[];
};
export declare function removeChildNodesAndEdgesFromStartPoint(nodeId: string, tempEdges: Edge[], tempNodes: Node<DefaultDataType>[]): void;
export declare function createNewNode({ selectedNodeType, values, nodes, position, }: {
    selectedNodeType: string;
    nodes: Node<DefaultDataType>[];
    values: Partial<DefaultDataType>;
    position?: XYPosition;
}): Node<DefaultDataType>;
export declare function createNewEdge({ sourceNodeId, sourceHandleId, edges, targetNodeId, data, }: {
    sourceNodeId: string;
    sourceHandleId?: string | null;
    edges: Edge<EdgeData>[];
    targetNodeId: string;
    data: EdgeData;
}): Edge<EdgeData>;
export declare function allocateId(prefix: string, items: {
    id: string;
}[]): string;
export declare function isSingleEdgeRemoval(change: EdgeChange[], edges: Edge[]): boolean;
export declare function roundToNearestTwenty(num: number): number;
export interface CreateRepeatNodeStructureParams {
    newNode: Node<DefaultDataType>;
    nodes: Node<DefaultDataType>[];
    edges: Edge[];
    position: XYPosition;
    connectingStartNodeId: {
        nodeId: string;
        handleId: string;
    } | null;
    screenId: string;
    elementId: string;
    getStyleWidth: (node: {
        style?: React.CSSProperties;
        width?: number | null;
    }, fallback: number) => number;
    scheduleGroupResize: (groupId: string) => void;
}
export interface CreateRepeatNodeStructureResult {
    nodes: Node<DefaultDataType>[];
    edges: Edge[];
    updatedNodes: Node<DefaultDataType>[];
}
/**
 * Creates the group, anchored repeat, and end repeat nodes for a repeat node.
 * Also links the group with the anchored repeat and the anchored repeat with the end repeat.
 * Also sets the branch flags for the source node if it is a condition node.
 * Also schedules a group resize for the parent group if this is a nested group.
 */
export declare function createRepeatNodeStructure({ newNode, nodes, edges, position, connectingStartNodeId, screenId, elementId, getStyleWidth, scheduleGroupResize, }: CreateRepeatNodeStructureParams): CreateRepeatNodeStructureResult;
//# sourceMappingURL=workflow-component-utils.d.ts.map