import type { Edge, Node } from 'reactflow';
import type { DefaultDataType, WorkflowFieldValue } from './workflow-types';
/**
 * Hook that manages the entire undo/redo history for the workflow.
 * Centralizes the logic for snapshots, history navigation, and related states.
 */
export interface HistoryState {
    history: Array<WorkflowFieldValue>;
    historyIndex: number;
    canRedo: boolean;
    isWorkflowDirty: boolean;
    isUndoDisabled: boolean;
    isRedoDisabled: boolean;
    takeHistorySnapshot: () => void;
    onUndo: () => void;
    onRedo: () => void;
    resetHistory: () => void;
}
export declare function useHistoryState(nodes: Node<DefaultDataType>[], edges: Edge[], setNodes: (nodes: Node<DefaultDataType>[]) => void, setEdges: (edges: Edge[]) => void): HistoryState;
//# sourceMappingURL=use-history-state.d.ts.map