import * as React from 'react';
import type { Node } from 'reactflow';
import type { DefaultDataType } from './workflow-types';
/**
 * Hook that handles auto-resizing of groups
 * Concentrates the logic for detecting when to resize and the resizing algorithm
 */
export interface GroupAutoResizeState {
    scheduleGroupResize: (groupId?: string) => void;
}
export declare function useGroupAutoResize(nodes: Node<DefaultDataType>[], setNodes: (nodes: Node<DefaultDataType>[]) => void, isDragging: React.MutableRefObject<boolean>, getStyleWidth: (node: {
    style?: React.CSSProperties;
    width?: number | null;
}, fallback: number) => number, getStyleHeight: (node: {
    style?: React.CSSProperties;
    height?: number | null;
}, fallback: number) => number): GroupAutoResizeState;
//# sourceMappingURL=use-group-auto-resize.d.ts.map