import * as React from 'react';
import { WorkflowContext } from '../workflow-context-provider';
import { useFieldValue } from '../../../../utils/hooks/effects/use-set-field-value';
/**
 * Group node used to create Sub Flows (parent/child relationships) in React Flow.
 * This node does not expose handles and acts as a visual container for child nodes.
 */
export function SubflowNode({ id }) {
    const context = React.useContext(WorkflowContext);
    const fieldValue = useFieldValue(context?.screenId, context?.elementId);
    let depth = 0;
    if (fieldValue?.nodes && id) {
        const byId = new Map(fieldValue.nodes.map(n => [n.id, n]));
        let current = byId.get(id);
        while (current && current.parentId) {
            depth += 1;
            current = byId.get(current.parentId);
        }
    }
    const levelClass = `e-workflow-subflow-level-${Math.min(depth, 5)}`;
    // Manual resize is disabled to follow UX; group resizes automatically based on content
    return React.createElement("div", { className: `e-workflow-subflow-node ${levelClass}`, "data-nodeid": id });
}
export default SubflowNode;
//# sourceMappingURL=subflow-node.js.map