import * as React from 'react';
import { useDeepEqualSelector } from '../../../utils/hooks/use-deep-equal-selector';
import { RepeatNode } from './nodes/repeat-node';
import { ConditionNode } from './nodes/condition-node';
import { StandardNode } from './nodes/standard-node';
export function CustomNode(props) {
    const { data, isConnectable, id, selected, type, zIndex, xPos, yPos, dragHandle, dragging, targetPosition, sourcePosition, } = props;
    const workflowNodeType = useDeepEqualSelector(s => {
        const all = s.workflowNodes || [];
        const exact = all.find(n => n.key === data.type);
        if (exact)
            return exact;
        const baseKey = data.type?.split('/')?.[0];
        if (!baseKey)
            return null;
        return all.find(n => n.key === baseKey) || null;
    });
    const nodeType = React.useMemo(() => workflowNodeType ||
        (data.type?.split('/')?.[0] === 'repeat'
            ? { key: 'repeat', type: 'action', title: 'repeat' }
            : data.type?.split('/')?.[0] === 'endRepeat'
                ? { key: 'endRepeat', type: 'action', title: 'End repeat' }
                : null), [workflowNodeType, data.type]);
    const configurationPage = workflowNodeType?.configurationPage;
    if (!nodeType) {
        return null;
    }
    // Common props for all specialized components
    const commonProps = {
        data,
        isConnectable,
        id,
        selected,
        type,
        zIndex,
        xPos,
        yPos,
        dragHandle,
        dragging,
        targetPosition,
        sourcePosition,
        nodeType,
        configurationPage,
    };
    // Dispatch to appropriate component based on node type
    const isRepeatType = data.type?.split('/')?.[0] === 'repeat' || data.type?.split('/')?.[0] === 'endRepeat';
    const isConditionType = nodeType.type === 'condition';
    if (isRepeatType) {
        return (React.createElement(RepeatNode, { data: commonProps.data, isConnectable: commonProps.isConnectable, id: commonProps.id, selected: commonProps.selected, type: commonProps.type, zIndex: commonProps.zIndex, xPos: commonProps.xPos, yPos: commonProps.yPos, dragHandle: commonProps.dragHandle, dragging: commonProps.dragging, targetPosition: commonProps.targetPosition, sourcePosition: commonProps.sourcePosition, nodeType: commonProps.nodeType, configurationPage: commonProps.configurationPage }));
    }
    if (isConditionType) {
        return (React.createElement(ConditionNode, { data: commonProps.data, isConnectable: commonProps.isConnectable, id: commonProps.id, selected: commonProps.selected, type: commonProps.type, zIndex: commonProps.zIndex, xPos: commonProps.xPos, yPos: commonProps.yPos, dragHandle: commonProps.dragHandle, dragging: commonProps.dragging, targetPosition: commonProps.targetPosition, sourcePosition: commonProps.sourcePosition, nodeType: commonProps.nodeType, configurationPage: commonProps.configurationPage }));
    }
    // Standard node (Normal node with a single connection)
    return (React.createElement(StandardNode, { data: commonProps.data, isConnectable: commonProps.isConnectable, id: commonProps.id, selected: commonProps.selected, type: commonProps.type, zIndex: commonProps.zIndex, xPos: commonProps.xPos, yPos: commonProps.yPos, dragHandle: commonProps.dragHandle, dragging: commonProps.dragging, targetPosition: commonProps.targetPosition, sourcePosition: commonProps.sourcePosition, nodeType: commonProps.nodeType, configurationPage: commonProps.configurationPage }));
}
//# sourceMappingURL=custom-node.js.map