import React from 'react';
import { EdgeLabelRenderer, BaseEdge, getSmoothStepPath } from 'reactflow';
import * as tokens from '@sage/design-tokens/js/base/common';
import { AddNewNodeEdgeLabel } from './add-new-node-edge-label';
import { WorkflowContext } from './workflow-context-provider';
import { useFieldValue } from '../../../utils/hooks/effects/use-set-field-value';
export function CustomEdge({ id, sourceX, sourceY, targetX, targetY, sourcePosition, targetPosition, markerEnd, selected, style, }) {
    const workflowContext = React.useContext(WorkflowContext);
    const isReadOnly = workflowContext?.isReadOnly ?? false;
    const fieldValue = useFieldValue(workflowContext?.screenId, workflowContext?.elementId);
    const edge = React.useMemo(() => fieldValue?.edges?.find(e => e.id === id), [fieldValue?.edges, id]);
    const sourceNode = React.useMemo(() => fieldValue?.nodes?.find(n => n.id === edge?.source), [edge?.source, fieldValue?.nodes]);
    const targetNode = React.useMemo(() => fieldValue?.nodes?.find(n => n.id === edge?.target), [edge?.target, fieldValue?.nodes]);
    // Support composed types like "repeat/_generic-1"
    const sourceType = sourceNode?.type?.split('/')?.[0];
    const targetType = targetNode?.type?.split('/')?.[0];
    const hideRepeatToEndRepeat = sourceType === 'repeat' && targetType === 'endRepeat';
    const [edgePath, centerX, centerY] = getSmoothStepPath({
        sourceX,
        sourceY,
        sourcePosition,
        targetX,
        targetY,
        targetPosition,
        borderRadius: 20,
    });
    if (hideRepeatToEndRepeat) {
        return React.createElement(React.Fragment, null);
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(BaseEdge, { id: id, path: edgePath, markerEnd: markerEnd, style: { ...style, stroke: selected ? tokens.colorsSemanticFocus500 : '#A6A6A6' } }),
        React.createElement(EdgeLabelRenderer, null, !isReadOnly && React.createElement(AddNewNodeEdgeLabel, { edgeId: id, centerX: centerX, centerY: centerY }))));
}
//# sourceMappingURL=custom-edge.js.map