import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedFormDesignerComponent = React.lazy(() => import('./workflow-component'));
export function AsyncConnectedWorkflowComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedFormDesignerComponent, { ...props })));
}
const WorkflowComponent = React.lazy(() => import('./workflow-component').then(c => ({ default: c.WorkflowComponent })));
export function AsyncFormDesignerComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(WorkflowComponent, { ...props })));
}
//# sourceMappingURL=async-workflow-component.js.map