/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { VitalPodProperties } from './vital-pod-types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export declare class VitalPodControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.VitalPod, FieldComponentProps<FieldKey.VitalPod>> {
    static readonly defaultUiProperties: Partial<VitalPodProperties>;
    /** Graphql filter that will restrict the results of the reference field */
    get filter(): GraphQLFilter<NodeType> | undefined;
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter: GraphQLFilter<NodeType> | undefined);
    /** The GraphQL node that the field suggestions will be fetched from */
    get node(): string;
    /** The helper text underneath the field */
    helperText?: string;
    /** Whether the value of the pod can be unset */
    canRemove?: boolean;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    refresh(): Promise<void>;
    focus(): void;
}
//# sourceMappingURL=vital-pod-control-object.d.ts.map